<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerManagementPendingDsk StructType
 * @subpackage Structs
 */
class CustomerManagementPendingDsk extends AbstractStructBase
{
    /**
     * The DskId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DskId;
    /**
     * The PendingNodeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PendingNodeId;
    /**
     * The QrCodeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $QrCodeId;
    /**
     * The DeviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceKey;
    /**
     * The DeviceDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceDesc;
    /**
     * Constructor method for CustomerManagementPendingDsk
     * @uses CustomerManagementPendingDsk::setDskId()
     * @uses CustomerManagementPendingDsk::setPendingNodeId()
     * @uses CustomerManagementPendingDsk::setQrCodeId()
     * @uses CustomerManagementPendingDsk::setDeviceKey()
     * @uses CustomerManagementPendingDsk::setDeviceDesc()
     * @param int $dskId
     * @param int $pendingNodeId
     * @param int $qrCodeId
     * @param string $deviceKey
     * @param string $deviceDesc
     */
    public function __construct($dskId = null, $pendingNodeId = null, $qrCodeId = null, $deviceKey = null, $deviceDesc = null)
    {
        $this
            ->setDskId($dskId)
            ->setPendingNodeId($pendingNodeId)
            ->setQrCodeId($qrCodeId)
            ->setDeviceKey($deviceKey)
            ->setDeviceDesc($deviceDesc);
    }
    /**
     * Get DskId value
     * @return int
     */
    public function getDskId()
    {
        return $this->DskId;
    }
    /**
     * Set DskId value
     * @param int $dskId
     * @return \CustomerManagement\StructType\CustomerManagementPendingDsk
     */
    public function setDskId($dskId = null)
    {
        // validation for constraint: int
        if (!is_null($dskId) && !(is_int($dskId) || ctype_digit($dskId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dskId, true), gettype($dskId)), __LINE__);
        }
        $this->DskId = $dskId;
        return $this;
    }
    /**
     * Get PendingNodeId value
     * @return int
     */
    public function getPendingNodeId()
    {
        return $this->PendingNodeId;
    }
    /**
     * Set PendingNodeId value
     * @param int $pendingNodeId
     * @return \CustomerManagement\StructType\CustomerManagementPendingDsk
     */
    public function setPendingNodeId($pendingNodeId = null)
    {
        // validation for constraint: int
        if (!is_null($pendingNodeId) && !(is_int($pendingNodeId) || ctype_digit($pendingNodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingNodeId, true), gettype($pendingNodeId)), __LINE__);
        }
        $this->PendingNodeId = $pendingNodeId;
        return $this;
    }
    /**
     * Get QrCodeId value
     * @return int
     */
    public function getQrCodeId()
    {
        return $this->QrCodeId;
    }
    /**
     * Set QrCodeId value
     * @param int $qrCodeId
     * @return \CustomerManagement\StructType\CustomerManagementPendingDsk
     */
    public function setQrCodeId($qrCodeId = null)
    {
        // validation for constraint: int
        if (!is_null($qrCodeId) && !(is_int($qrCodeId) || ctype_digit($qrCodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qrCodeId, true), gettype($qrCodeId)), __LINE__);
        }
        $this->QrCodeId = $qrCodeId;
        return $this;
    }
    /**
     * Get DeviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->DeviceKey;
    }
    /**
     * Set DeviceKey value
     * @param string $deviceKey
     * @return \CustomerManagement\StructType\CustomerManagementPendingDsk
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->DeviceKey = $deviceKey;
        return $this;
    }
    /**
     * Get DeviceDesc value
     * @return string|null
     */
    public function getDeviceDesc()
    {
        return $this->DeviceDesc;
    }
    /**
     * Set DeviceDesc value
     * @param string $deviceDesc
     * @return \CustomerManagement\StructType\CustomerManagementPendingDsk
     */
    public function setDeviceDesc($deviceDesc = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDesc) && !is_string($deviceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceDesc, true), gettype($deviceDesc)), __LINE__);
        }
        $this->DeviceDesc = $deviceDesc;
        return $this;
    }
}
