<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetScheduledAppointmentInput StructType
 * @subpackage Structs
 */
class GetScheduledAppointmentInput extends AbstractStructBase
{
    /**
     * The AppointmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AppointmentId;
    /**
     * Constructor method for GetScheduledAppointmentInput
     * @uses GetScheduledAppointmentInput::setAppointmentId()
     * @param int $appointmentId
     */
    public function __construct($appointmentId = null)
    {
        $this
            ->setAppointmentId($appointmentId);
    }
    /**
     * Get AppointmentId value
     * @return int
     */
    public function getAppointmentId()
    {
        return $this->AppointmentId;
    }
    /**
     * Set AppointmentId value
     * @param int $appointmentId
     * @return \CustomerManagement\StructType\GetScheduledAppointmentInput
     */
    public function setAppointmentId($appointmentId = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentId) && !(is_int($appointmentId) || ctype_digit($appointmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appointmentId, true), gettype($appointmentId)), __LINE__);
        }
        $this->AppointmentId = $appointmentId;
        return $this;
    }
}
