<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearEngineersResetInput StructType
 * @subpackage Structs
 */
class ClearEngineersResetInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The PartitionNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PartitionNumber;
    /**
     * Constructor method for ClearEngineersResetInput
     * @uses ClearEngineersResetInput::setCustomerId()
     * @uses ClearEngineersResetInput::setPartitionNumber()
     * @param int $customerId
     * @param int $partitionNumber
     */
    public function __construct($customerId = null, $partitionNumber = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPartitionNumber($partitionNumber);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ClearEngineersResetInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get PartitionNumber value
     * @return int
     */
    public function getPartitionNumber()
    {
        return $this->PartitionNumber;
    }
    /**
     * Set PartitionNumber value
     * @param int $partitionNumber
     * @return \CustomerManagement\StructType\ClearEngineersResetInput
     */
    public function setPartitionNumber($partitionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($partitionNumber) && !(is_int($partitionNumber) || ctype_digit($partitionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partitionNumber, true), gettype($partitionNumber)), __LINE__);
        }
        $this->PartitionNumber = $partitionNumber;
        return $this;
    }
}
