<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableWifiNetworksOutput StructType
 * @subpackage Structs
 */
class GetAvailableWifiNetworksOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The WiFiNetworks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo
     */
    public $WiFiNetworks;
    /**
     * Constructor method for GetAvailableWifiNetworksOutput
     * @uses GetAvailableWifiNetworksOutput::setSuccess()
     * @uses GetAvailableWifiNetworksOutput::setErrorMessage()
     * @uses GetAvailableWifiNetworksOutput::setWiFiNetworks()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setWiFiNetworks($wiFiNetworks);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get WiFiNetworks value
     * @return \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo|null
     */
    public function getWiFiNetworks()
    {
        return $this->WiFiNetworks;
    }
    /**
     * Set WiFiNetworks value
     * @param \CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksOutput
     */
    public function setWiFiNetworks(\CustomerManagement\ArrayType\ArrayOfWiFiNetworkInfo $wiFiNetworks = null)
    {
        $this->WiFiNetworks = $wiFiNetworks;
        return $this;
    }
}
