<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUserCodeOutput StructType
 * @subpackage Structs
 */
class AddUserCodeOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The PanelUserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelUserID;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for AddUserCodeOutput
     * @uses AddUserCodeOutput::setSuccess()
     * @uses AddUserCodeOutput::setPanelUserID()
     * @uses AddUserCodeOutput::setErrorMessage()
     * @param bool $success
     * @param int $panelUserID
     * @param string $errorMessage
     */
    public function __construct($success = null, $panelUserID = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setPanelUserID($panelUserID)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\AddUserCodeOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get PanelUserID value
     * @return int
     */
    public function getPanelUserID()
    {
        return $this->PanelUserID;
    }
    /**
     * Set PanelUserID value
     * @param int $panelUserID
     * @return \CustomerManagement\StructType\AddUserCodeOutput
     */
    public function setPanelUserID($panelUserID = null)
    {
        // validation for constraint: int
        if (!is_null($panelUserID) && !(is_int($panelUserID) || ctype_digit($panelUserID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelUserID, true), gettype($panelUserID)), __LINE__);
        }
        $this->PanelUserID = $panelUserID;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\AddUserCodeOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
