<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetElectricityPlansOutput StructType
 * @subpackage Structs
 */
class GetElectricityPlansOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ElectricityPlans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfElectricityPlanInfo
     */
    public $ElectricityPlans;
    /**
     * Constructor method for GetElectricityPlansOutput
     * @uses GetElectricityPlansOutput::setSuccess()
     * @uses GetElectricityPlansOutput::setErrorMessage()
     * @uses GetElectricityPlansOutput::setElectricityPlans()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfElectricityPlanInfo $electricityPlans
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfElectricityPlanInfo $electricityPlans = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setElectricityPlans($electricityPlans);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetElectricityPlansOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetElectricityPlansOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ElectricityPlans value
     * @return \CustomerManagement\ArrayType\ArrayOfElectricityPlanInfo|null
     */
    public function getElectricityPlans()
    {
        return $this->ElectricityPlans;
    }
    /**
     * Set ElectricityPlans value
     * @param \CustomerManagement\ArrayType\ArrayOfElectricityPlanInfo $electricityPlans
     * @return \CustomerManagement\StructType\GetElectricityPlansOutput
     */
    public function setElectricityPlans(\CustomerManagement\ArrayType\ArrayOfElectricityPlanInfo $electricityPlans = null)
    {
        $this->ElectricityPlans = $electricityPlans;
        return $this;
    }
}
