<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoiceAccessLevelsOutput StructType
 * @subpackage Structs
 */
class GetVoiceAccessLevelsOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The VoiceAccessLevelMappings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping
     */
    public $VoiceAccessLevelMappings;
    /**
     * Constructor method for GetVoiceAccessLevelsOutput
     * @uses GetVoiceAccessLevelsOutput::setSuccess()
     * @uses GetVoiceAccessLevelsOutput::setErrorMessage()
     * @uses GetVoiceAccessLevelsOutput::setVoiceAccessLevelMappings()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setVoiceAccessLevelMappings($voiceAccessLevelMappings);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetVoiceAccessLevelsOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetVoiceAccessLevelsOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get VoiceAccessLevelMappings value
     * @return \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping|null
     */
    public function getVoiceAccessLevelMappings()
    {
        return $this->VoiceAccessLevelMappings;
    }
    /**
     * Set VoiceAccessLevelMappings value
     * @param \CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings
     * @return \CustomerManagement\StructType\GetVoiceAccessLevelsOutput
     */
    public function setVoiceAccessLevelMappings(\CustomerManagement\ArrayType\ArrayOfVoiceAccessLevelMapping $voiceAccessLevelMappings = null)
    {
        $this->VoiceAccessLevelMappings = $voiceAccessLevelMappings;
        return $this;
    }
}
