<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentlyUsedDetectors StructType
 * @subpackage Structs
 */
class FrequentlyUsedDetectors extends AbstractStructBase
{
    /**
     * The Days
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Days;
    /**
     * The SAMSensors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfFrequentlyUsedDeviceItem
     */
    public $SAMSensors;
    /**
     * Constructor method for FrequentlyUsedDetectors
     * @uses FrequentlyUsedDetectors::setDays()
     * @uses FrequentlyUsedDetectors::setSAMSensors()
     * @param int $days
     * @param \CustomerManagement\ArrayType\ArrayOfFrequentlyUsedDeviceItem $sAMSensors
     */
    public function __construct($days = null, \CustomerManagement\ArrayType\ArrayOfFrequentlyUsedDeviceItem $sAMSensors = null)
    {
        $this
            ->setDays($days)
            ->setSAMSensors($sAMSensors);
    }
    /**
     * Get Days value
     * @return int
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \CustomerManagement\StructType\FrequentlyUsedDetectors
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !(is_int($days) || ctype_digit($days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get SAMSensors value
     * @return \CustomerManagement\ArrayType\ArrayOfFrequentlyUsedDeviceItem|null
     */
    public function getSAMSensors()
    {
        return $this->SAMSensors;
    }
    /**
     * Set SAMSensors value
     * @param \CustomerManagement\ArrayType\ArrayOfFrequentlyUsedDeviceItem $sAMSensors
     * @return \CustomerManagement\StructType\FrequentlyUsedDetectors
     */
    public function setSAMSensors(\CustomerManagement\ArrayType\ArrayOfFrequentlyUsedDeviceItem $sAMSensors = null)
    {
        $this->SAMSensors = $sAMSensors;
        return $this;
    }
}
