<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferAccountInput StructType
 * @subpackage Structs
 */
class TransferAccountInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DestinationDealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DestinationDealerId;
    /**
     * Constructor method for TransferAccountInput
     * @uses TransferAccountInput::setCustomerId()
     * @uses TransferAccountInput::setDestinationDealerId()
     * @param int $customerId
     * @param int $destinationDealerId
     */
    public function __construct($customerId = null, $destinationDealerId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDestinationDealerId($destinationDealerId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\TransferAccountInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DestinationDealerId value
     * @return int
     */
    public function getDestinationDealerId()
    {
        return $this->DestinationDealerId;
    }
    /**
     * Set DestinationDealerId value
     * @param int $destinationDealerId
     * @return \CustomerManagement\StructType\TransferAccountInput
     */
    public function setDestinationDealerId($destinationDealerId = null)
    {
        // validation for constraint: int
        if (!is_null($destinationDealerId) && !(is_int($destinationDealerId) || ctype_digit($destinationDealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationDealerId, true), gettype($destinationDealerId)), __LINE__);
        }
        $this->DestinationDealerId = $destinationDealerId;
        return $this;
    }
}
