<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminateModemInput StructType
 * @subpackage Structs
 */
class TerminateModemInput extends AbstractStructBase
{
    /**
     * The ForceFullTermination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ForceFullTermination;
    /**
     * The ModemSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemSerial;
    /**
     * Constructor method for TerminateModemInput
     * @uses TerminateModemInput::setForceFullTermination()
     * @uses TerminateModemInput::setModemSerial()
     * @param bool $forceFullTermination
     * @param string $modemSerial
     */
    public function __construct($forceFullTermination = null, $modemSerial = null)
    {
        $this
            ->setForceFullTermination($forceFullTermination)
            ->setModemSerial($modemSerial);
    }
    /**
     * Get ForceFullTermination value
     * @return bool
     */
    public function getForceFullTermination()
    {
        return $this->ForceFullTermination;
    }
    /**
     * Set ForceFullTermination value
     * @param bool $forceFullTermination
     * @return \CustomerManagement\StructType\TerminateModemInput
     */
    public function setForceFullTermination($forceFullTermination = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceFullTermination) && !is_bool($forceFullTermination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceFullTermination, true), gettype($forceFullTermination)), __LINE__);
        }
        $this->ForceFullTermination = $forceFullTermination;
        return $this;
    }
    /**
     * Get ModemSerial value
     * @return string|null
     */
    public function getModemSerial()
    {
        return $this->ModemSerial;
    }
    /**
     * Set ModemSerial value
     * @param string $modemSerial
     * @return \CustomerManagement\StructType\TerminateModemInput
     */
    public function setModemSerial($modemSerial = null)
    {
        // validation for constraint: string
        if (!is_null($modemSerial) && !is_string($modemSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modemSerial, true), gettype($modemSerial)), __LINE__);
        }
        $this->ModemSerial = $modemSerial;
        return $this;
    }
}
