<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for VocabularyNameEnum EnumType
 * @subpackage Enumerations
 */
class VocabularyNameEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'DeviceType'
     * @return string 'DeviceType'
     */
    const VALUE_DEVICE_TYPE = 'DeviceType';
    /**
     * Constant for value 'AlarmDotComGroup'
     * @return string 'AlarmDotComGroup'
     */
    const VALUE_ALARM_DOT_COM_GROUP = 'AlarmDotComGroup';
    /**
     * Constant for value 'EventType'
     * @return string 'EventType'
     */
    const VALUE_EVENT_TYPE = 'EventType';
    /**
     * Constant for value 'CSEventGroups'
     * @return string 'CSEventGroups'
     */
    const VALUE_CSEVENT_GROUPS = 'CSEventGroups';
    /**
     * Constant for value 'Addons'
     * @return string 'Addons'
     */
    const VALUE_ADDONS = 'Addons';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_DEVICE_TYPE
     * @uses self::VALUE_ALARM_DOT_COM_GROUP
     * @uses self::VALUE_EVENT_TYPE
     * @uses self::VALUE_CSEVENT_GROUPS
     * @uses self::VALUE_ADDONS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_DEVICE_TYPE,
            self::VALUE_ALARM_DOT_COM_GROUP,
            self::VALUE_EVENT_TYPE,
            self::VALUE_CSEVENT_GROUPS,
            self::VALUE_ADDONS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
