<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveRemoteRoutineInspectionInput StructType
 * @subpackage Structs
 */
class RetrieveRemoteRoutineInspectionInput extends AbstractStructBase
{
    /**
     * The RRIInstanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RRIInstanceCode;
    /**
     * Constructor method for RetrieveRemoteRoutineInspectionInput
     * @uses RetrieveRemoteRoutineInspectionInput::setRRIInstanceCode()
     * @param int $rRIInstanceCode
     */
    public function __construct($rRIInstanceCode = null)
    {
        $this
            ->setRRIInstanceCode($rRIInstanceCode);
    }
    /**
     * Get RRIInstanceCode value
     * @return int
     */
    public function getRRIInstanceCode()
    {
        return $this->RRIInstanceCode;
    }
    /**
     * Set RRIInstanceCode value
     * @param int $rRIInstanceCode
     * @return \CustomerManagement\StructType\RetrieveRemoteRoutineInspectionInput
     */
    public function setRRIInstanceCode($rRIInstanceCode = null)
    {
        // validation for constraint: int
        if (!is_null($rRIInstanceCode) && !(is_int($rRIInstanceCode) || ctype_digit($rRIInstanceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rRIInstanceCode, true), gettype($rRIInstanceCode)), __LINE__);
        }
        $this->RRIInstanceCode = $rRIInstanceCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\RetrieveRemoteRoutineInspectionInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
