<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageSensorUploadsOutput StructType
 * @subpackage Structs
 */
class ImageSensorUploadsOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The NumberOfCaptures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfCaptures;
    /**
     * The NumberOfUploads
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfUploads;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMsg;
    /**
     * Constructor method for ImageSensorUploadsOutput
     * @uses ImageSensorUploadsOutput::setSuccess()
     * @uses ImageSensorUploadsOutput::setNumberOfCaptures()
     * @uses ImageSensorUploadsOutput::setNumberOfUploads()
     * @uses ImageSensorUploadsOutput::setErrorMsg()
     * @param bool $success
     * @param int $numberOfCaptures
     * @param int $numberOfUploads
     * @param string $errorMsg
     */
    public function __construct($success = null, $numberOfCaptures = null, $numberOfUploads = null, $errorMsg = null)
    {
        $this
            ->setSuccess($success)
            ->setNumberOfCaptures($numberOfCaptures)
            ->setNumberOfUploads($numberOfUploads)
            ->setErrorMsg($errorMsg);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\ImageSensorUploadsOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get NumberOfCaptures value
     * @return int
     */
    public function getNumberOfCaptures()
    {
        return $this->NumberOfCaptures;
    }
    /**
     * Set NumberOfCaptures value
     * @param int $numberOfCaptures
     * @return \CustomerManagement\StructType\ImageSensorUploadsOutput
     */
    public function setNumberOfCaptures($numberOfCaptures = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCaptures) && !(is_int($numberOfCaptures) || ctype_digit($numberOfCaptures))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfCaptures, true), gettype($numberOfCaptures)), __LINE__);
        }
        $this->NumberOfCaptures = $numberOfCaptures;
        return $this;
    }
    /**
     * Get NumberOfUploads value
     * @return int
     */
    public function getNumberOfUploads()
    {
        return $this->NumberOfUploads;
    }
    /**
     * Set NumberOfUploads value
     * @param int $numberOfUploads
     * @return \CustomerManagement\StructType\ImageSensorUploadsOutput
     */
    public function setNumberOfUploads($numberOfUploads = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUploads) && !(is_int($numberOfUploads) || ctype_digit($numberOfUploads))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUploads, true), gettype($numberOfUploads)), __LINE__);
        }
        $this->NumberOfUploads = $numberOfUploads;
        return $this;
    }
    /**
     * Get ErrorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->ErrorMsg;
    }
    /**
     * Set ErrorMsg value
     * @param string $errorMsg
     * @return \CustomerManagement\StructType\ImageSensorUploadsOutput
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->ErrorMsg = $errorMsg;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ImageSensorUploadsOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
