<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DeviceClassEnum EnumType
 * @subpackage Enumerations
 */
class DeviceClassEnum
{
    /**
     * Constant for value 'Partition'
     * @return string 'Partition'
     */
    const VALUE_PARTITION = 'Partition';
    /**
     * Constant for value 'WirelessSensor'
     * @return string 'WirelessSensor'
     */
    const VALUE_WIRELESS_SENSOR = 'WirelessSensor';
    /**
     * Constant for value 'WiredSensor'
     * @return string 'WiredSensor'
     */
    const VALUE_WIRED_SENSOR = 'WiredSensor';
    /**
     * Constant for value 'Keyfob'
     * @return string 'Keyfob'
     */
    const VALUE_KEYFOB = 'Keyfob';
    /**
     * Constant for value 'KeypadTouchscreens'
     * @return string 'KeypadTouchscreens'
     */
    const VALUE_KEYPAD_TOUCHSCREENS = 'KeypadTouchscreens';
    /**
     * Constant for value 'Siren'
     * @return string 'Siren'
     */
    const VALUE_SIREN = 'Siren';
    /**
     * Constant for value 'Repeater'
     * @return string 'Repeater'
     */
    const VALUE_REPEATER = 'Repeater';
    /**
     * Constant for value 'ExpanderModule'
     * @return string 'ExpanderModule'
     */
    const VALUE_EXPANDER_MODULE = 'ExpanderModule';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'OutputExpander'
     * @return string 'OutputExpander'
     */
    const VALUE_OUTPUT_EXPANDER = 'OutputExpander';
    /**
     * Constant for value 'PowerSupply'
     * @return string 'PowerSupply'
     */
    const VALUE_POWER_SUPPLY = 'PowerSupply';
    /**
     * Constant for value 'HighCurrentOutput'
     * @return string 'HighCurrentOutput'
     */
    const VALUE_HIGH_CURRENT_OUTPUT = 'HighCurrentOutput';
    /**
     * Constant for value 'RFTransceiver'
     * @return string 'RFTransceiver'
     */
    const VALUE_RFTRANSCEIVER = 'RFTransceiver';
    /**
     * Constant for value 'AudioModule'
     * @return string 'AudioModule'
     */
    const VALUE_AUDIO_MODULE = 'AudioModule';
    /**
     * Constant for value 'BusZoneExpander'
     * @return string 'BusZoneExpander'
     */
    const VALUE_BUS_ZONE_EXPANDER = 'BusZoneExpander';
    /**
     * Constant for value 'WifiTablet'
     * @return string 'WifiTablet'
     */
    const VALUE_WIFI_TABLET = 'WifiTablet';
    /**
     * Constant for value 'HighCurrentPowerSupply'
     * @return string 'HighCurrentPowerSupply'
     */
    const VALUE_HIGH_CURRENT_POWER_SUPPLY = 'HighCurrentPowerSupply';
    /**
     * Constant for value 'IOExpanderModule'
     * @return string 'IOExpanderModule'
     */
    const VALUE_IOEXPANDER_MODULE = 'IOExpanderModule';
    /**
     * Constant for value 'CorbusRepeater'
     * @return string 'CorbusRepeater'
     */
    const VALUE_CORBUS_REPEATER = 'CorbusRepeater';
    /**
     * Constant for value 'Controller'
     * @return string 'Controller'
     */
    const VALUE_CONTROLLER = 'Controller';
    /**
     * Constant for value 'VirtualZone'
     * @return string 'VirtualZone'
     */
    const VALUE_VIRTUAL_ZONE = 'VirtualZone';
    /**
     * Constant for value 'Pendant'
     * @return string 'Pendant'
     */
    const VALUE_PENDANT = 'Pendant';
    /**
     * Constant for value 'Tag'
     * @return string 'Tag'
     */
    const VALUE_TAG = 'Tag';
    /**
     * Constant for value 'CloudDeviceAlexaRange1'
     * @return string 'CloudDeviceAlexaRange1'
     */
    const VALUE_CLOUD_DEVICE_ALEXA_RANGE_1 = 'CloudDeviceAlexaRange1';
    /**
     * Constant for value 'CloudDeviceAlexaRange2'
     * @return string 'CloudDeviceAlexaRange2'
     */
    const VALUE_CLOUD_DEVICE_ALEXA_RANGE_2 = 'CloudDeviceAlexaRange2';
    /**
     * Constant for value 'CloudDeviceAlexaRange3'
     * @return string 'CloudDeviceAlexaRange3'
     */
    const VALUE_CLOUD_DEVICE_ALEXA_RANGE_3 = 'CloudDeviceAlexaRange3';
    /**
     * Constant for value 'CloudDeviceAlexaRange4'
     * @return string 'CloudDeviceAlexaRange4'
     */
    const VALUE_CLOUD_DEVICE_ALEXA_RANGE_4 = 'CloudDeviceAlexaRange4';
    /**
     * Constant for value 'CloudDeviceLowerRange'
     * @return string 'CloudDeviceLowerRange'
     */
    const VALUE_CLOUD_DEVICE_LOWER_RANGE = 'CloudDeviceLowerRange';
    /**
     * Constant for value 'CloudDeviceUpperRange'
     * @return string 'CloudDeviceUpperRange'
     */
    const VALUE_CLOUD_DEVICE_UPPER_RANGE = 'CloudDeviceUpperRange';
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PARTITION
     * @uses self::VALUE_WIRELESS_SENSOR
     * @uses self::VALUE_WIRED_SENSOR
     * @uses self::VALUE_KEYFOB
     * @uses self::VALUE_KEYPAD_TOUCHSCREENS
     * @uses self::VALUE_SIREN
     * @uses self::VALUE_REPEATER
     * @uses self::VALUE_EXPANDER_MODULE
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_OUTPUT_EXPANDER
     * @uses self::VALUE_POWER_SUPPLY
     * @uses self::VALUE_HIGH_CURRENT_OUTPUT
     * @uses self::VALUE_RFTRANSCEIVER
     * @uses self::VALUE_AUDIO_MODULE
     * @uses self::VALUE_BUS_ZONE_EXPANDER
     * @uses self::VALUE_WIFI_TABLET
     * @uses self::VALUE_HIGH_CURRENT_POWER_SUPPLY
     * @uses self::VALUE_IOEXPANDER_MODULE
     * @uses self::VALUE_CORBUS_REPEATER
     * @uses self::VALUE_CONTROLLER
     * @uses self::VALUE_VIRTUAL_ZONE
     * @uses self::VALUE_PENDANT
     * @uses self::VALUE_TAG
     * @uses self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_1
     * @uses self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_2
     * @uses self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_3
     * @uses self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_4
     * @uses self::VALUE_CLOUD_DEVICE_LOWER_RANGE
     * @uses self::VALUE_CLOUD_DEVICE_UPPER_RANGE
     * @uses self::VALUE_USER
     * @uses self::VALUE_INVALID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PARTITION,
            self::VALUE_WIRELESS_SENSOR,
            self::VALUE_WIRED_SENSOR,
            self::VALUE_KEYFOB,
            self::VALUE_KEYPAD_TOUCHSCREENS,
            self::VALUE_SIREN,
            self::VALUE_REPEATER,
            self::VALUE_EXPANDER_MODULE,
            self::VALUE_OTHER,
            self::VALUE_OUTPUT_EXPANDER,
            self::VALUE_POWER_SUPPLY,
            self::VALUE_HIGH_CURRENT_OUTPUT,
            self::VALUE_RFTRANSCEIVER,
            self::VALUE_AUDIO_MODULE,
            self::VALUE_BUS_ZONE_EXPANDER,
            self::VALUE_WIFI_TABLET,
            self::VALUE_HIGH_CURRENT_POWER_SUPPLY,
            self::VALUE_IOEXPANDER_MODULE,
            self::VALUE_CORBUS_REPEATER,
            self::VALUE_CONTROLLER,
            self::VALUE_VIRTUAL_ZONE,
            self::VALUE_PENDANT,
            self::VALUE_TAG,
            self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_1,
            self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_2,
            self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_3,
            self::VALUE_CLOUD_DEVICE_ALEXA_RANGE_4,
            self::VALUE_CLOUD_DEVICE_LOWER_RANGE,
            self::VALUE_CLOUD_DEVICE_UPPER_RANGE,
            self::VALUE_USER,
            self::VALUE_INVALID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
