<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventDatetimePair StructType
 * @subpackage Structs
 */
class EventDatetimePair extends AbstractStructBase
{
    /**
     * The TimestampUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TimestampUtc;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Event;
    /**
     * Constructor method for EventDatetimePair
     * @uses EventDatetimePair::setTimestampUtc()
     * @uses EventDatetimePair::setEvent()
     * @param string $timestampUtc
     * @param string $event
     */
    public function __construct($timestampUtc = null, $event = null)
    {
        $this
            ->setTimestampUtc($timestampUtc)
            ->setEvent($event);
    }
    /**
     * Get TimestampUtc value
     * @return string
     */
    public function getTimestampUtc()
    {
        return $this->TimestampUtc;
    }
    /**
     * Set TimestampUtc value
     * @param string $timestampUtc
     * @return \CustomerManagement\StructType\EventDatetimePair
     */
    public function setTimestampUtc($timestampUtc = null)
    {
        // validation for constraint: string
        if (!is_null($timestampUtc) && !is_string($timestampUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampUtc, true), gettype($timestampUtc)), __LINE__);
        }
        $this->TimestampUtc = $timestampUtc;
        return $this;
    }
    /**
     * Get Event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param string $event
     * @return \CustomerManagement\StructType\EventDatetimePair
     */
    public function setEvent($event = null)
    {
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($event, true), gettype($event)), __LINE__);
        }
        $this->Event = $event;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\EventDatetimePair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
