<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvancedStats StructType
 * @subpackage Structs
 */
class AdvancedStats extends AbstractStructBase
{
    /**
     * The RSSI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $RSSI;
    /**
     * The NormalizedSignalStrength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NormalizedSignalStrength;
    /**
     * The SNR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SNR;
    /**
     * The TxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TxRate;
    /**
     * Constructor method for AdvancedStats
     * @uses AdvancedStats::setRSSI()
     * @uses AdvancedStats::setNormalizedSignalStrength()
     * @uses AdvancedStats::setSNR()
     * @uses AdvancedStats::setTxRate()
     * @param float $rSSI
     * @param int $normalizedSignalStrength
     * @param float $sNR
     * @param float $txRate
     */
    public function __construct($rSSI = null, $normalizedSignalStrength = null, $sNR = null, $txRate = null)
    {
        $this
            ->setRSSI($rSSI)
            ->setNormalizedSignalStrength($normalizedSignalStrength)
            ->setSNR($sNR)
            ->setTxRate($txRate);
    }
    /**
     * Get RSSI value
     * @return float
     */
    public function getRSSI()
    {
        return $this->RSSI;
    }
    /**
     * Set RSSI value
     * @param float $rSSI
     * @return \CustomerManagement\StructType\AdvancedStats
     */
    public function setRSSI($rSSI = null)
    {
        // validation for constraint: float
        if (!is_null($rSSI) && !(is_float($rSSI) || is_numeric($rSSI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rSSI, true), gettype($rSSI)), __LINE__);
        }
        $this->RSSI = $rSSI;
        return $this;
    }
    /**
     * Get NormalizedSignalStrength value
     * @return int
     */
    public function getNormalizedSignalStrength()
    {
        return $this->NormalizedSignalStrength;
    }
    /**
     * Set NormalizedSignalStrength value
     * @param int $normalizedSignalStrength
     * @return \CustomerManagement\StructType\AdvancedStats
     */
    public function setNormalizedSignalStrength($normalizedSignalStrength = null)
    {
        // validation for constraint: int
        if (!is_null($normalizedSignalStrength) && !(is_int($normalizedSignalStrength) || ctype_digit($normalizedSignalStrength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($normalizedSignalStrength, true), gettype($normalizedSignalStrength)), __LINE__);
        }
        $this->NormalizedSignalStrength = $normalizedSignalStrength;
        return $this;
    }
    /**
     * Get SNR value
     * @return float
     */
    public function getSNR()
    {
        return $this->SNR;
    }
    /**
     * Set SNR value
     * @param float $sNR
     * @return \CustomerManagement\StructType\AdvancedStats
     */
    public function setSNR($sNR = null)
    {
        // validation for constraint: float
        if (!is_null($sNR) && !(is_float($sNR) || is_numeric($sNR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sNR, true), gettype($sNR)), __LINE__);
        }
        $this->SNR = $sNR;
        return $this;
    }
    /**
     * Get TxRate value
     * @return float
     */
    public function getTxRate()
    {
        return $this->TxRate;
    }
    /**
     * Set TxRate value
     * @param float $txRate
     * @return \CustomerManagement\StructType\AdvancedStats
     */
    public function setTxRate($txRate = null)
    {
        // validation for constraint: float
        if (!is_null($txRate) && !(is_float($txRate) || is_numeric($txRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($txRate, true), gettype($txRate)), __LINE__);
        }
        $this->TxRate = $txRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AdvancedStats
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
