<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DevicePurchaserEnum EnumType
 * @subpackage Enumerations
 */
class DevicePurchaserEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Dealer'
     * @return string 'Dealer'
     */
    const VALUE_DEALER = 'Dealer';
    /**
     * Constant for value 'Builder'
     * @return string 'Builder'
     */
    const VALUE_BUILDER = 'Builder';
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_DEALER
     * @uses self::VALUE_BUILDER
     * @uses self::VALUE_CUSTOMER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_DEALER,
            self::VALUE_BUILDER,
            self::VALUE_CUSTOMER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
