<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetSecurityQuestions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns the list of available security questions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSecurityQuestions $parameters
     * @return \CustomerManagement\StructType\GetSecurityQuestionsResponse|bool
     */
    public function GetSecurityQuestions(\CustomerManagement\StructType\GetSecurityQuestions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSecurityQuestions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllLogins_V2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all login names for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAllLogins_V2 $parameters
     * @return \CustomerManagement\StructType\GetAllLogins_V2Response|bool
     */
    public function GetAllLogins_V2(\CustomerManagement\StructType\GetAllLogins_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllLogins_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllLogins
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all login names for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAllLogins $parameters
     * @return \CustomerManagement\StructType\GetAllLoginsResponse|bool
     */
    public function GetAllLogins(\CustomerManagement\StructType\GetAllLogins $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllLogins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoginInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get basic info for customer logins and the summary of all customers that are associated with them.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLoginInfo $parameters
     * @return \CustomerManagement\StructType\GetLoginInfoResponse|bool
     */
    public function GetLoginInfo(\CustomerManagement\StructType\GetLoginInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLoginInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerEnergyProgramEligibility
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of all customers within a specific program area.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerEnergyProgramEligibility $parameters
     * @return \CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityResponse|bool
     */
    public function GetCustomerEnergyProgramEligibility(\CustomerManagement\StructType\GetCustomerEnergyProgramEligibility $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerEnergyProgramEligibility($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImageSensorLatestCaptureInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Image Sensor Latest Capture info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetImageSensorLatestCaptureInfo $parameters
     * @return \CustomerManagement\StructType\GetImageSensorLatestCaptureInfoResponse|bool
     */
    public function GetImageSensorLatestCaptureInfo(\CustomerManagement\StructType\GetImageSensorLatestCaptureInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetImageSensorLatestCaptureInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImageSensorUploadsInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Image Sensor number of uploads info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetImageSensorUploadsInfo $parameters
     * @return \CustomerManagement\StructType\GetImageSensorUploadsInfoResponse|bool
     */
    public function GetImageSensorUploadsInfo(\CustomerManagement\StructType\GetImageSensorUploadsInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetImageSensorUploadsInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEligibleSensorGroups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of eligible sensor groups given a unit ID.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetEligibleSensorGroups $parameters
     * @return \CustomerManagement\StructType\GetEligibleSensorGroupsResponse|bool
     */
    public function GetEligibleSensorGroups(\CustomerManagement\StructType\GetEligibleSensorGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEligibleSensorGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEligibleSensorNames
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns a list of eligible sensor names.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetEligibleSensorNames $parameters
     * @return \CustomerManagement\StructType\GetEligibleSensorNamesResponse|bool
     */
    public function GetEligibleSensorNames(\CustomerManagement\StructType\GetEligibleSensorNames $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEligibleSensorNames($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserCodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all user codes for a specific customer. This will return all user codes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetUserCodes $parameters
     * @return \CustomerManagement\StructType\GetUserCodesResponse|bool
     */
    public function GetUserCodes(\CustomerManagement\StructType\GetUserCodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableWifiNetworks
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all available wifi network names.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAvailableWifiNetworks $parameters
     * @return \CustomerManagement\StructType\GetAvailableWifiNetworksResponse|bool
     */
    public function GetAvailableWifiNetworks(\CustomerManagement\StructType\GetAvailableWifiNetworks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableWifiNetworks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerBestPractices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Customer Best Practices.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerBestPractices $parameters
     * @return \CustomerManagement\StructType\GetCustomerBestPracticesResponse|bool
     */
    public function GetCustomerBestPractices(\CustomerManagement\StructType\GetCustomerBestPractices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerBestPractices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCommunicationSetting
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the dual path communication mode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCommunicationSetting $parameters
     * @return \CustomerManagement\StructType\GetCommunicationSettingResponse|bool
     */
    public function GetCommunicationSetting(\CustomerManagement\StructType\GetCommunicationSetting $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCommunicationSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDualPathCommunicationStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the dual path communication status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDualPathCommunicationStatus $parameters
     * @return \CustomerManagement\StructType\GetDualPathCommunicationStatusResponse|bool
     */
    public function GetDualPathCommunicationStatus(\CustomerManagement\StructType\GetDualPathCommunicationStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDualPathCommunicationStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventHistory
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of recent events. Note that the time frame is limited to 1 day.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetEventHistory $parameters
     * @return \CustomerManagement\StructType\GetEventHistoryResponse|bool
     */
    public function GetEventHistory(\CustomerManagement\StructType\GetEventHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInstantaneousMode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets the current setting for Instantaneous mode for sensor activity (beta).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetInstantaneousMode $parameters
     * @return \CustomerManagement\StructType\GetInstantaneousModeResponse|bool
     */
    public function GetInstantaneousMode(\CustomerManagement\StructType\GetInstantaneousMode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInstantaneousMode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPendingCommandInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: See if there are any commands waiting to be sent to the system (beta).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetPendingCommandInfo $parameters
     * @return \CustomerManagement\StructType\GetPendingCommandInfoResponse|bool
     */
    public function GetPendingCommandInfo(\CustomerManagement\StructType\GetPendingCommandInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPendingCommandInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLatestCallerVersion
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Tells you the latest CallerVersion. CallerVersion is used by a few calls to avoid backwards compatibility problems with enumerations.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLatestCallerVersion $parameters
     * @return \CustomerManagement\StructType\GetLatestCallerVersionResponse|bool
     */
    public function GetLatestCallerVersion(\CustomerManagement\StructType\GetLatestCallerVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLatestCallerVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllCommitments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get commitments for a dealer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAllCommitments $parameters
     * @return \CustomerManagement\StructType\GetAllCommitmentsResponse|bool
     */
    public function GetAllCommitments(\CustomerManagement\StructType\GetAllCommitments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllCommitments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRefreshToken
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Generates a refresh token for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetRefreshToken $parameters
     * @return \CustomerManagement\StructType\GetRefreshTokenResponse|bool
     */
    public function GetRefreshToken(\CustomerManagement\StructType\GetRefreshToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRefreshToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoiceAccessLevels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets the customers voice access levels for PSU/Report State.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetVoiceAccessLevels $parameters
     * @return \CustomerManagement\StructType\GetVoiceAccessLevelsResponse|bool
     */
    public function GetVoiceAccessLevels(\CustomerManagement\StructType\GetVoiceAccessLevels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoiceAccessLevels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOnsiteWrapUpStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the status of the most recent on-site wrap up.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetOnsiteWrapUpStatus $parameters
     * @return \CustomerManagement\StructType\GetOnsiteWrapUpStatusResponse|bool
     */
    public function GetOnsiteWrapUpStatus(\CustomerManagement\StructType\GetOnsiteWrapUpStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOnsiteWrapUpStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetScheduledAppointment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a scheduled service appointment for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetScheduledAppointment $parameters
     * @return \CustomerManagement\StructType\GetScheduledAppointmentResponse|bool
     */
    public function GetScheduledAppointment(\CustomerManagement\StructType\GetScheduledAppointment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetScheduledAppointment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInteractiveLockoutStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Interactive Lockout status of a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetInteractiveLockoutStatus $parameters
     * @return \CustomerManagement\StructType\GetInteractiveLockoutStatusResponse|bool
     */
    public function GetInteractiveLockoutStatus(\CustomerManagement\StructType\GetInteractiveLockoutStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInteractiveLockoutStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReturnUrl
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get return URL of a page by its name
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetReturnUrl $parameters
     * @return \CustomerManagement\StructType\GetReturnUrlResponse|bool
     */
    public function GetReturnUrl(\CustomerManagement\StructType\GetReturnUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReturnUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSolarSystems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all active solar sites/systems related to the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSolarSystems $parameters
     * @return \CustomerManagement\StructType\GetSolarSystemsResponse|bool
     */
    public function GetSolarSystems(\CustomerManagement\StructType\GetSolarSystems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSolarSystems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSolarData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all active solar sites/systems related to the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSolarData $parameters
     * @return \CustomerManagement\StructType\GetSolarDataResponse|bool
     */
    public function GetSolarData(\CustomerManagement\StructType\GetSolarData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSolarData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetElectricityProviders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Electricity Providers/Utilities for the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetElectricityProviders $parameters
     * @return \CustomerManagement\StructType\GetElectricityProvidersResponse|bool
     */
    public function GetElectricityProviders(\CustomerManagement\StructType\GetElectricityProviders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetElectricityProviders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetElectricityPlans
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Electricity Plans for the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetElectricityPlans $parameters
     * @return \CustomerManagement\StructType\GetElectricityPlansResponse|bool
     */
    public function GetElectricityPlans(\CustomerManagement\StructType\GetElectricityPlans $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetElectricityPlans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeviceNotes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all general and equipment device notes related to the customer in context.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDeviceNotes $parameters
     * @return \CustomerManagement\StructType\GetDeviceNotesResponse|bool
     */
    public function GetDeviceNotes(\CustomerManagement\StructType\GetDeviceNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeviceNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPendingZwaveDeviceSpecificKeys
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of pending Z-Wave device specific keys (DSKs) for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetPendingZwaveDeviceSpecificKeys $parameters
     * @return \CustomerManagement\StructType\GetPendingZwaveDeviceSpecificKeysResponse|bool
     */
    public function GetPendingZwaveDeviceSpecificKeys(\CustomerManagement\StructType\GetPendingZwaveDeviceSpecificKeys $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPendingZwaveDeviceSpecificKeys($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVocabularies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get Alarm.com vocabulary by name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetVocabularies $parameters
     * @return \CustomerManagement\StructType\GetVocabulariesResponse|bool
     */
    public function GetVocabularies(\CustomerManagement\StructType\GetVocabularies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVocabularies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAdvancedWifiStatsForVideoDevice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets current advanced wifi statistics for supported video devices.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetAdvancedWifiStatsForVideoDevice $parameters
     * @return \CustomerManagement\StructType\GetAdvancedWifiStatsForVideoDeviceResponse|bool
     */
    public function GetAdvancedWifiStatsForVideoDevice(\CustomerManagement\StructType\GetAdvancedWifiStatsForVideoDevice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAdvancedWifiStatsForVideoDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetModemSerialFromIccid
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetModemSerialFromIccid $parameters
     * @return \CustomerManagement\StructType\GetModemSerialFromIccidResponse|bool
     */
    public function GetModemSerialFromIccid(\CustomerManagement\StructType\GetModemSerialFromIccid $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetModemSerialFromIccid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSimStatusDuringActivation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets the Carrier Status for a panel during the activation phase.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSimStatusDuringActivation $parameters
     * @return \CustomerManagement\StructType\GetSimStatusDuringActivationResponse|bool
     */
    public function GetSimStatusDuringActivation(\CustomerManagement\StructType\GetSimStatusDuringActivation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSimStatusDuringActivation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastMessageDate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Deprecated. Please use GetLastPanelDate.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLastMessageDate $parameters
     * @return \CustomerManagement\StructType\GetLastMessageDateResponse|bool
     */
    public function GetLastMessageDate(\CustomerManagement\StructType\GetLastMessageDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastMessageDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPanelDate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Loads the last panel date for the specified customer and panel date type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLastPanelDate $parameters
     * @return \CustomerManagement\StructType\GetLastPanelDateResponse|bool
     */
    public function GetLastPanelDate(\CustomerManagement\StructType\GetLastPanelDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPanelDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastCsEventDate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Deprecated. Please use GetLastPanelDate.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetLastCsEventDate $parameters
     * @return \CustomerManagement\StructType\GetLastCsEventDateResponse|bool
     */
    public function GetLastCsEventDate(\CustomerManagement\StructType\GetLastCsEventDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastCsEventDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSignalStrengthSummary
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets the Alarm.com Customer Last Signaling Activity/Summary Information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSignalStrengthSummary $parameters
     * @return \CustomerManagement\StructType\GetSignalStrengthSummaryResponse|bool
     */
    public function GetSignalStrengthSummary(\CustomerManagement\StructType\GetSignalStrengthSummary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSignalStrengthSummary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSignalStrengthHistory
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSignalStrengthHistory $parameters
     * @return \CustomerManagement\StructType\GetSignalStrengthHistoryResponse|bool
     */
    public function GetSignalStrengthHistory(\CustomerManagement\StructType\GetSignalStrengthHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSignalStrengthHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeviceList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDeviceList $parameters
     * @return \CustomerManagement\StructType\GetDeviceListResponse|bool
     */
    public function GetDeviceList(\CustomerManagement\StructType\GetDeviceList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeviceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFullEquipmentList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets all equipment from the Alarm.com equipment list, including cameras, zwave devices, fake devices for partitions, ...
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetFullEquipmentList $parameters
     * @return \CustomerManagement\StructType\GetFullEquipmentListResponse|bool
     */
    public function GetFullEquipmentList(\CustomerManagement\StructType\GetFullEquipmentList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFullEquipmentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVideoDeviceInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets all video cameras from the Alarm.com equipment list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetVideoDeviceInfo $parameters
     * @return \CustomerManagement\StructType\GetVideoDeviceInfoResponse|bool
     */
    public function GetVideoDeviceInfo(\CustomerManagement\StructType\GetVideoDeviceInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVideoDeviceInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete. Please call GetCustomerInfo_V2 instead, which improves backwards compatibility by allowing the server to know the API version supported by the client.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerInfo $parameters
     * @return \CustomerManagement\StructType\GetCustomerInfoResponse|bool
     */
    public function GetCustomerInfo(\CustomerManagement\StructType\GetCustomerInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerInfo_V2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a customer's information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerInfo_V2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerInfo_V2Response|bool
     */
    public function GetCustomerInfo_V2(\CustomerManagement\StructType\GetCustomerInfo_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerInfo_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerPrice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a customer's service plan info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerPrice $parameters
     * @return \CustomerManagement\StructType\GetCustomerPriceResponse|bool
     */
    public function GetCustomerPrice(\CustomerManagement\StructType\GetCustomerPrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerTroubleConditions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete, use GetCustomerTroubleConditions_v2 instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerTroubleConditions $parameters
     * @return \CustomerManagement\StructType\GetCustomerTroubleConditionsResponse|bool
     */
    public function GetCustomerTroubleConditions(\CustomerManagement\StructType\GetCustomerTroubleConditions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerTroubleConditions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerTroubleConditions_v2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a customer's trouble conditions.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerTroubleConditions_v2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerTroubleConditions_v2Response|bool
     */
    public function GetCustomerTroubleConditions_v2(\CustomerManagement\StructType\GetCustomerTroubleConditions_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerTroubleConditions_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete, use GetCustomerListWithTroubleConditions_v2 instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditions $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsResponse|bool
     */
    public function GetCustomerListWithTroubleConditions(\CustomerManagement\StructType\GetCustomerListWithTroubleConditions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListWithTroubleConditions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditions_v2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of customers matching the trouble condition criteria.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2Response|bool
     */
    public function GetCustomerListWithTroubleConditions_v2(\CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListWithTroubleConditions_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditionsCsv
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Obsolete. Use GetCustomerListWithTroubleConditionsCsv_v2 instead.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsvResponse|bool
     */
    public function GetCustomerListWithTroubleConditionsCsv(\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListWithTroubleConditionsCsv($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetCustomerListWithTroubleConditionsCsv_v2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of customers matching the trouble condition criteria. Use this method if you have a lot of customers because the performance is much better. Columns: customer_id, device_id, TroubleCondition (TroubleConditionTypeEnum),
     * trouble start date (in UTC).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2Response|bool
     */
    public function GetCustomerListWithTroubleConditionsCsv_v2(\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListWithTroubleConditionsCsv_v2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetResolvedTroubleConditionsCsv
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Gets trouble conditions that have been resolved in the past 60 days. A customer ID can be passed in to restrict the output
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetResolvedTroubleConditionsCsv $parameters
     * @return \CustomerManagement\StructType\GetResolvedTroubleConditionsCsvResponse|bool
     */
    public function GetResolvedTroubleConditionsCsv(\CustomerManagement\StructType\GetResolvedTroubleConditionsCsv $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetResolvedTroubleConditionsCsv($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemCheckResults
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the Latest System Check Results for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetSystemCheckResults $parameters
     * @return \CustomerManagement\StructType\GetSystemCheckResultsResponse|bool
     */
    public function GetSystemCheckResults(\CustomerManagement\StructType\GetSystemCheckResults $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSystemCheckResults($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListWithPanelSetting
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the customers IDs that your login has access to and have a certain value for a panel setting.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListWithPanelSetting $parameters
     * @return \CustomerManagement\StructType\GetCustomerListWithPanelSettingResponse|bool
     */
    public function GetCustomerListWithPanelSetting(\CustomerManagement\StructType\GetCustomerListWithPanelSetting $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListWithPanelSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the customers IDs that your login has access to.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerList $parameters
     * @return \CustomerManagement\StructType\GetCustomerListResponse|bool
     */
    public function GetCustomerList(\CustomerManagement\StructType\GetCustomerList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerList_V2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the customers IDs that your login has access to that matches search criteria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerList_V2 $parameters
     * @return \CustomerManagement\StructType\GetCustomerList_V2Response|bool
     */
    public function GetCustomerList_V2(\CustomerManagement\StructType\GetCustomerList_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerList_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListByBranchId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the customers IDs that belong to a branch/sub-dealer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListByBranchId $parameters
     * @return \CustomerManagement\StructType\GetCustomerListByBranchIdResponse|bool
     */
    public function GetCustomerListByBranchId(\CustomerManagement\StructType\GetCustomerListByBranchId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListByBranchId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListByEmail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the IDs of customers that use the specified email address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListByEmail $parameters
     * @return \CustomerManagement\StructType\GetCustomerListByEmailResponse|bool
     */
    public function GetCustomerListByEmail(\CustomerManagement\StructType\GetCustomerListByEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListByEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerListByLoginName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a list of the IDs of customers that have the specified login name.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetCustomerListByLoginName $parameters
     * @return \CustomerManagement\StructType\GetCustomerListByLoginNameResponse|bool
     */
    public function GetCustomerListByLoginName(\CustomerManagement\StructType\GetCustomerListByLoginName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerListByLoginName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDownloadableSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns the list of downloadable settings with some information about valid options for each.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetDownloadableSettings $parameters
     * @return \CustomerManagement\StructType\GetDownloadableSettingsResponse|bool
     */
    public function GetDownloadableSettings(\CustomerManagement\StructType\GetDownloadableSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDownloadableSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUploadedPanelSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns already uploaded settings from the panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetUploadedPanelSettings $parameters
     * @return \CustomerManagement\StructType\GetUploadedPanelSettingsResponse|bool
     */
    public function GetUploadedPanelSettings(\CustomerManagement\StructType\GetUploadedPanelSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUploadedPanelSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImageSensorInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retrieves detailed information about an image sensor camera.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetImageSensorInfo $parameters
     * @return \CustomerManagement\StructType\GetImageSensorInfoResponse|bool
     */
    public function GetImageSensorInfo(\CustomerManagement\StructType\GetImageSensorInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetImageSensorInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPauseNotificationsForCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns the time(in UTC) that notifications will resume for a customer, as well as if that customer has logged in yet.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\GetPauseNotificationsForCustomer $parameters
     * @return \CustomerManagement\StructType\GetPauseNotificationsForCustomerResponse|bool
     */
    public function GetPauseNotificationsForCustomer(\CustomerManagement\StructType\GetPauseNotificationsForCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPauseNotificationsForCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\GetAdvancedWifiStatsForVideoDeviceResponse|\CustomerManagement\StructType\GetAllCommitmentsResponse|\CustomerManagement\StructType\GetAllLoginsResponse|\CustomerManagement\StructType\GetAllLogins_V2Response|\CustomerManagement\StructType\GetAvailableWifiNetworksResponse|\CustomerManagement\StructType\GetCommunicationSettingResponse|\CustomerManagement\StructType\GetCustomerBestPracticesResponse|\CustomerManagement\StructType\GetCustomerEnergyProgramEligibilityResponse|\CustomerManagement\StructType\GetCustomerInfoResponse|\CustomerManagement\StructType\GetCustomerInfo_V2Response|\CustomerManagement\StructType\GetCustomerListByBranchIdResponse|\CustomerManagement\StructType\GetCustomerListByEmailResponse|\CustomerManagement\StructType\GetCustomerListByLoginNameResponse|\CustomerManagement\StructType\GetCustomerListResponse|\CustomerManagement\StructType\GetCustomerListWithPanelSettingResponse|\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsvResponse|\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsCsv_v2Response|\CustomerManagement\StructType\GetCustomerListWithTroubleConditionsResponse|\CustomerManagement\StructType\GetCustomerListWithTroubleConditions_v2Response|\CustomerManagement\StructType\GetCustomerList_V2Response|\CustomerManagement\StructType\GetCustomerPriceResponse|\CustomerManagement\StructType\GetCustomerTroubleConditionsResponse|\CustomerManagement\StructType\GetCustomerTroubleConditions_v2Response|\CustomerManagement\StructType\GetDeviceListResponse|\CustomerManagement\StructType\GetDeviceNotesResponse|\CustomerManagement\StructType\GetDownloadableSettingsResponse|\CustomerManagement\StructType\GetDualPathCommunicationStatusResponse|\CustomerManagement\StructType\GetElectricityPlansResponse|\CustomerManagement\StructType\GetElectricityProvidersResponse|\CustomerManagement\StructType\GetEligibleSensorGroupsResponse|\CustomerManagement\StructType\GetEligibleSensorNamesResponse|\CustomerManagement\StructType\GetEventHistoryResponse|\CustomerManagement\StructType\GetFullEquipmentListResponse|\CustomerManagement\StructType\GetImageSensorInfoResponse|\CustomerManagement\StructType\GetImageSensorLatestCaptureInfoResponse|\CustomerManagement\StructType\GetImageSensorUploadsInfoResponse|\CustomerManagement\StructType\GetInstantaneousModeResponse|\CustomerManagement\StructType\GetInteractiveLockoutStatusResponse|\CustomerManagement\StructType\GetLastCsEventDateResponse|\CustomerManagement\StructType\GetLastMessageDateResponse|\CustomerManagement\StructType\GetLastPanelDateResponse|\CustomerManagement\StructType\GetLatestCallerVersionResponse|\CustomerManagement\StructType\GetLoginInfoResponse|\CustomerManagement\StructType\GetModemSerialFromIccidResponse|\CustomerManagement\StructType\GetOnsiteWrapUpStatusResponse|\CustomerManagement\StructType\GetPauseNotificationsForCustomerResponse|\CustomerManagement\StructType\GetPendingCommandInfoResponse|\CustomerManagement\StructType\GetPendingZwaveDeviceSpecificKeysResponse|\CustomerManagement\StructType\GetRefreshTokenResponse|\CustomerManagement\StructType\GetResolvedTroubleConditionsCsvResponse|\CustomerManagement\StructType\GetReturnUrlResponse|\CustomerManagement\StructType\GetScheduledAppointmentResponse|\CustomerManagement\StructType\GetSecurityQuestionsResponse|\CustomerManagement\StructType\GetSignalStrengthHistoryResponse|\CustomerManagement\StructType\GetSignalStrengthSummaryResponse|\CustomerManagement\StructType\GetSimStatusDuringActivationResponse|\CustomerManagement\StructType\GetSolarDataResponse|\CustomerManagement\StructType\GetSolarSystemsResponse|\CustomerManagement\StructType\GetSystemCheckResultsResponse|\CustomerManagement\StructType\GetUploadedPanelSettingsResponse|\CustomerManagement\StructType\GetUserCodesResponse|\CustomerManagement\StructType\GetVideoDeviceInfoResponse|\CustomerManagement\StructType\GetVocabulariesResponse|\CustomerManagement\StructType\GetVoiceAccessLevelsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
