<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for TaskTypeEnum EnumType
 * @subpackage Enumerations
 */
class TaskTypeEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'SuccessfulSystemCheck'
     * @return string 'SuccessfulSystemCheck'
     */
    const VALUE_SUCCESSFUL_SYSTEM_CHECK = 'SuccessfulSystemCheck';
    /**
     * Constant for value 'CustomTask'
     * @return string 'CustomTask'
     */
    const VALUE_CUSTOM_TASK = 'CustomTask';
    /**
     * Constant for value 'MobileLogIn'
     * @return string 'MobileLogIn'
     */
    const VALUE_MOBILE_LOG_IN = 'MobileLogIn';
    /**
     * Constant for value 'SaveDeviceNotes'
     * @return string 'SaveDeviceNotes'
     */
    const VALUE_SAVE_DEVICE_NOTES = 'SaveDeviceNotes';
    /**
     * Constant for value 'EnableDualPath'
     * @return string 'EnableDualPath'
     */
    const VALUE_ENABLE_DUAL_PATH = 'EnableDualPath';
    /**
     * Constant for value 'LteUpgradeNeeded'
     * @return string 'LteUpgradeNeeded'
     */
    const VALUE_LTE_UPGRADE_NEEDED = 'LteUpgradeNeeded';
    /**
     * Constant for value 'SensorWalkTest'
     * @return string 'SensorWalkTest'
     */
    const VALUE_SENSOR_WALK_TEST = 'SensorWalkTest';
    /**
     * Constant for value 'EmailVerified'
     * @return string 'EmailVerified'
     */
    const VALUE_EMAIL_VERIFIED = 'EmailVerified';
    /**
     * Constant for value 'MobileContact'
     * @return string 'MobileContact'
     */
    const VALUE_MOBILE_CONTACT = 'MobileContact';
    /**
     * Constant for value 'ArmingReminder'
     * @return string 'ArmingReminder'
     */
    const VALUE_ARMING_REMINDER = 'ArmingReminder';
    /**
     * Constant for value 'GeoDevice'
     * @return string 'GeoDevice'
     */
    const VALUE_GEO_DEVICE = 'GeoDevice';
    /**
     * Constant for value 'AdvancedDevice'
     * @return string 'AdvancedDevice'
     */
    const VALUE_ADVANCED_DEVICE = 'AdvancedDevice';
    /**
     * Constant for value 'RuleOrSchedule'
     * @return string 'RuleOrSchedule'
     */
    const VALUE_RULE_OR_SCHEDULE = 'RuleOrSchedule';
    /**
     * Constant for value 'OnOffTest'
     * @return string 'OnOffTest'
     */
    const VALUE_ON_OFF_TEST = 'OnOffTest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_SUCCESSFUL_SYSTEM_CHECK
     * @uses self::VALUE_CUSTOM_TASK
     * @uses self::VALUE_MOBILE_LOG_IN
     * @uses self::VALUE_SAVE_DEVICE_NOTES
     * @uses self::VALUE_ENABLE_DUAL_PATH
     * @uses self::VALUE_LTE_UPGRADE_NEEDED
     * @uses self::VALUE_SENSOR_WALK_TEST
     * @uses self::VALUE_EMAIL_VERIFIED
     * @uses self::VALUE_MOBILE_CONTACT
     * @uses self::VALUE_ARMING_REMINDER
     * @uses self::VALUE_GEO_DEVICE
     * @uses self::VALUE_ADVANCED_DEVICE
     * @uses self::VALUE_RULE_OR_SCHEDULE
     * @uses self::VALUE_ON_OFF_TEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_SUCCESSFUL_SYSTEM_CHECK,
            self::VALUE_CUSTOM_TASK,
            self::VALUE_MOBILE_LOG_IN,
            self::VALUE_SAVE_DEVICE_NOTES,
            self::VALUE_ENABLE_DUAL_PATH,
            self::VALUE_LTE_UPGRADE_NEEDED,
            self::VALUE_SENSOR_WALK_TEST,
            self::VALUE_EMAIL_VERIFIED,
            self::VALUE_MOBILE_CONTACT,
            self::VALUE_ARMING_REMINDER,
            self::VALUE_GEO_DEVICE,
            self::VALUE_ADVANCED_DEVICE,
            self::VALUE_RULE_OR_SCHEDULE,
            self::VALUE_ON_OFF_TEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
