<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DeviceInstallationMethodEnum EnumType
 * @subpackage Enumerations
 */
class DeviceInstallationMethodEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'AddDevicePortal'
     * @return string 'AddDevicePortal'
     */
    const VALUE_ADD_DEVICE_PORTAL = 'AddDevicePortal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_ADD_DEVICE_PORTAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_ADD_DEVICE_PORTAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
