<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElectricityPlanInfo StructType
 * @subpackage Structs
 */
class ElectricityPlanInfo extends AbstractStructBase
{
    /**
     * The MasterTariffId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MasterTariffId;
    /**
     * The TariffName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TariffName;
    /**
     * Constructor method for ElectricityPlanInfo
     * @uses ElectricityPlanInfo::setMasterTariffId()
     * @uses ElectricityPlanInfo::setTariffName()
     * @param int $masterTariffId
     * @param string $tariffName
     */
    public function __construct($masterTariffId = null, $tariffName = null)
    {
        $this
            ->setMasterTariffId($masterTariffId)
            ->setTariffName($tariffName);
    }
    /**
     * Get MasterTariffId value
     * @return int
     */
    public function getMasterTariffId()
    {
        return $this->MasterTariffId;
    }
    /**
     * Set MasterTariffId value
     * @param int $masterTariffId
     * @return \CustomerManagement\StructType\ElectricityPlanInfo
     */
    public function setMasterTariffId($masterTariffId = null)
    {
        // validation for constraint: int
        if (!is_null($masterTariffId) && !(is_int($masterTariffId) || ctype_digit($masterTariffId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masterTariffId, true), gettype($masterTariffId)), __LINE__);
        }
        $this->MasterTariffId = $masterTariffId;
        return $this;
    }
    /**
     * Get TariffName value
     * @return string|null
     */
    public function getTariffName()
    {
        return $this->TariffName;
    }
    /**
     * Set TariffName value
     * @param string $tariffName
     * @return \CustomerManagement\StructType\ElectricityPlanInfo
     */
    public function setTariffName($tariffName = null)
    {
        // validation for constraint: string
        if (!is_null($tariffName) && !is_string($tariffName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffName, true), gettype($tariffName)), __LINE__);
        }
        $this->TariffName = $tariffName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ElectricityPlanInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
