<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DeviceInstallerEnum EnumType
 * @subpackage Enumerations
 */
class DeviceInstallerEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'DealerRep'
     * @return string 'DealerRep'
     */
    const VALUE_DEALER_REP = 'DealerRep';
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Constant for value 'Builder'
     * @return string 'Builder'
     */
    const VALUE_BUILDER = 'Builder';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_DEALER_REP
     * @uses self::VALUE_CUSTOMER
     * @uses self::VALUE_BUILDER
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_DEALER_REP,
            self::VALUE_CUSTOMER,
            self::VALUE_BUILDER,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
