<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentlyUsedDetectors StructType
 * @subpackage Structs
 */
class FrequentlyUsedDetectors extends AbstractStructBase
{
    /**
     * The Days
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Days;
    /**
     * The Zones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt1
     */
    public $Zones;
    /**
     * The SAMSensors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt2
     */
    public $SAMSensors;
    /**
     * Constructor method for FrequentlyUsedDetectors
     * @uses FrequentlyUsedDetectors::setDays()
     * @uses FrequentlyUsedDetectors::setZones()
     * @uses FrequentlyUsedDetectors::setSAMSensors()
     * @param int $days
     * @param \CustomerManagement\ArrayType\ArrayOfInt1 $zones
     * @param \CustomerManagement\ArrayType\ArrayOfInt2 $sAMSensors
     */
    public function __construct($days = null, \CustomerManagement\ArrayType\ArrayOfInt1 $zones = null, \CustomerManagement\ArrayType\ArrayOfInt2 $sAMSensors = null)
    {
        $this
            ->setDays($days)
            ->setZones($zones)
            ->setSAMSensors($sAMSensors);
    }
    /**
     * Get Days value
     * @return int
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \CustomerManagement\StructType\FrequentlyUsedDetectors
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !(is_int($days) || ctype_digit($days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get Zones value
     * @return \CustomerManagement\ArrayType\ArrayOfInt1|null
     */
    public function getZones()
    {
        return $this->Zones;
    }
    /**
     * Set Zones value
     * @param \CustomerManagement\ArrayType\ArrayOfInt1 $zones
     * @return \CustomerManagement\StructType\FrequentlyUsedDetectors
     */
    public function setZones(\CustomerManagement\ArrayType\ArrayOfInt1 $zones = null)
    {
        $this->Zones = $zones;
        return $this;
    }
    /**
     * Get SAMSensors value
     * @return \CustomerManagement\ArrayType\ArrayOfInt2|null
     */
    public function getSAMSensors()
    {
        return $this->SAMSensors;
    }
    /**
     * Set SAMSensors value
     * @param \CustomerManagement\ArrayType\ArrayOfInt2 $sAMSensors
     * @return \CustomerManagement\StructType\FrequentlyUsedDetectors
     */
    public function setSAMSensors(\CustomerManagement\ArrayType\ArrayOfInt2 $sAMSensors = null)
    {
        $this->SAMSensors = $sAMSensors;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\FrequentlyUsedDetectors
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
