<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteCustomerLoginInput StructType
 * @subpackage Structs
 */
class DeleteCustomerLoginInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The LoginIdToDelete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginIdToDelete;
    /**
     * Constructor method for DeleteCustomerLoginInput
     * @uses DeleteCustomerLoginInput::setCustomerId()
     * @uses DeleteCustomerLoginInput::setLoginIdToDelete()
     * @param int $customerId
     * @param int $loginIdToDelete
     */
    public function __construct($customerId = null, $loginIdToDelete = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginIdToDelete($loginIdToDelete);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\DeleteCustomerLoginInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get LoginIdToDelete value
     * @return int
     */
    public function getLoginIdToDelete()
    {
        return $this->LoginIdToDelete;
    }
    /**
     * Set LoginIdToDelete value
     * @param int $loginIdToDelete
     * @return \CustomerManagement\StructType\DeleteCustomerLoginInput
     */
    public function setLoginIdToDelete($loginIdToDelete = null)
    {
        // validation for constraint: int
        if (!is_null($loginIdToDelete) && !(is_int($loginIdToDelete) || ctype_digit($loginIdToDelete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginIdToDelete, true), gettype($loginIdToDelete)), __LINE__);
        }
        $this->LoginIdToDelete = $loginIdToDelete;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\DeleteCustomerLoginInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
