<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInt1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfInt1 extends AbstractStructArrayBase
{
    /**
     * The ZoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $ZoneNumber;
    /**
     * Constructor method for ArrayOfInt1
     * @uses ArrayOfInt1::setZoneNumber()
     * @param int[] $zoneNumber
     */
    public function __construct(array $zoneNumber = array())
    {
        $this
            ->setZoneNumber($zoneNumber);
    }
    /**
     * Get ZoneNumber value
     * @return int[]|null
     */
    public function getZoneNumber()
    {
        return $this->ZoneNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setZoneNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZoneNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZoneNumberForArrayConstraintsFromSetZoneNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfInt1ZoneNumberItem) {
            // validation for constraint: itemType
            if (!(is_int($arrayOfInt1ZoneNumberItem) || ctype_digit($arrayOfInt1ZoneNumberItem))) {
                $invalidValues[] = is_object($arrayOfInt1ZoneNumberItem) ? get_class($arrayOfInt1ZoneNumberItem) : sprintf('%s(%s)', gettype($arrayOfInt1ZoneNumberItem), var_export($arrayOfInt1ZoneNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZoneNumber property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZoneNumber value
     * @throws \InvalidArgumentException
     * @param int[] $zoneNumber
     * @return \CustomerManagement\ArrayType\ArrayOfInt1
     */
    public function setZoneNumber(array $zoneNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($zoneNumberArrayErrorMessage = self::validateZoneNumberForArrayConstraintsFromSetZoneNumber($zoneNumber))) {
            throw new \InvalidArgumentException($zoneNumberArrayErrorMessage, __LINE__);
        }
        $this->ZoneNumber = $zoneNumber;
        return $this;
    }
    /**
     * Add item to ZoneNumber value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \CustomerManagement\ArrayType\ArrayOfInt1
     */
    public function addToZoneNumber($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The ZoneNumber property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZoneNumber[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ZoneNumber
     */
    public function getAttributeName()
    {
        return 'ZoneNumber';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfInt1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
