<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVocabulary ArrayType
 * @subpackage Arrays
 */
class ArrayOfVocabulary extends AbstractStructArrayBase
{
    /**
     * The Vocabulary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Vocabulary[]
     */
    public $Vocabulary;
    /**
     * Constructor method for ArrayOfVocabulary
     * @uses ArrayOfVocabulary::setVocabulary()
     * @param \CustomerManagement\StructType\Vocabulary[] $vocabulary
     */
    public function __construct(array $vocabulary = array())
    {
        $this
            ->setVocabulary($vocabulary);
    }
    /**
     * Get Vocabulary value
     * @return \CustomerManagement\StructType\Vocabulary[]|null
     */
    public function getVocabulary()
    {
        return $this->Vocabulary;
    }
    /**
     * This method is responsible for validating the values passed to the setVocabulary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVocabulary method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVocabularyForArrayConstraintsFromSetVocabulary(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfVocabularyVocabularyItem) {
            // validation for constraint: itemType
            if (!$arrayOfVocabularyVocabularyItem instanceof \CustomerManagement\StructType\Vocabulary) {
                $invalidValues[] = is_object($arrayOfVocabularyVocabularyItem) ? get_class($arrayOfVocabularyVocabularyItem) : sprintf('%s(%s)', gettype($arrayOfVocabularyVocabularyItem), var_export($arrayOfVocabularyVocabularyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vocabulary property can only contain items of type \CustomerManagement\StructType\Vocabulary, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vocabulary value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\Vocabulary[] $vocabulary
     * @return \CustomerManagement\ArrayType\ArrayOfVocabulary
     */
    public function setVocabulary(array $vocabulary = array())
    {
        // validation for constraint: array
        if ('' !== ($vocabularyArrayErrorMessage = self::validateVocabularyForArrayConstraintsFromSetVocabulary($vocabulary))) {
            throw new \InvalidArgumentException($vocabularyArrayErrorMessage, __LINE__);
        }
        $this->Vocabulary = $vocabulary;
        return $this;
    }
    /**
     * Add item to Vocabulary value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\Vocabulary $item
     * @return \CustomerManagement\ArrayType\ArrayOfVocabulary
     */
    public function addToVocabulary(\CustomerManagement\StructType\Vocabulary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\Vocabulary) {
            throw new \InvalidArgumentException(sprintf('The Vocabulary property can only contain items of type \CustomerManagement\StructType\Vocabulary, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vocabulary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\Vocabulary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\Vocabulary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\Vocabulary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\Vocabulary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\Vocabulary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Vocabulary
     */
    public function getAttributeName()
    {
        return 'Vocabulary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfVocabulary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
