<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for PeripheralDeviceTypeEnum EnumType
 * @subpackage Enumerations
 */
class PeripheralDeviceTypeEnum
{
    /**
     * Constant for value 'Keyfob'
     * @return string 'Keyfob'
     */
    const VALUE_KEYFOB = 'Keyfob';
    /**
     * Constant for value 'Siren'
     * @return string 'Siren'
     */
    const VALUE_SIREN = 'Siren';
    /**
     * Constant for value 'Repeater'
     * @return string 'Repeater'
     */
    const VALUE_REPEATER = 'Repeater';
    /**
     * Constant for value 'KeypadTouchscreens'
     * @return string 'KeypadTouchscreens'
     */
    const VALUE_KEYPAD_TOUCHSCREENS = 'KeypadTouchscreens';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEYFOB
     * @uses self::VALUE_SIREN
     * @uses self::VALUE_REPEATER
     * @uses self::VALUE_KEYPAD_TOUCHSCREENS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEYFOB,
            self::VALUE_SIREN,
            self::VALUE_REPEATER,
            self::VALUE_KEYPAD_TOUCHSCREENS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
