<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for PanelDateType EnumType
 * @subpackage Enumerations
 */
class PanelDateType
{
    /**
     * Constant for value 'LastArmDate'
     * @return string 'LastArmDate'
     */
    const VALUE_LAST_ARM_DATE = 'LastArmDate';
    /**
     * Constant for value 'LastCsEventDate'
     * @return string 'LastCsEventDate'
     */
    const VALUE_LAST_CS_EVENT_DATE = 'LastCsEventDate';
    /**
     * Constant for value 'LastMessageDate'
     * @return string 'LastMessageDate'
     */
    const VALUE_LAST_MESSAGE_DATE = 'LastMessageDate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LAST_ARM_DATE
     * @uses self::VALUE_LAST_CS_EVENT_DATE
     * @uses self::VALUE_LAST_MESSAGE_DATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LAST_ARM_DATE,
            self::VALUE_LAST_CS_EVENT_DATE,
            self::VALUE_LAST_MESSAGE_DATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
