<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NumberDatetimePair StructType
 * @subpackage Structs
 */
class NumberDatetimePair extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Number;
    /**
     * The TimestampUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TimestampUtc;
    /**
     * Constructor method for NumberDatetimePair
     * @uses NumberDatetimePair::setNumber()
     * @uses NumberDatetimePair::setTimestampUtc()
     * @param int $number
     * @param string $timestampUtc
     */
    public function __construct($number = null, $timestampUtc = null)
    {
        $this
            ->setNumber($number)
            ->setTimestampUtc($timestampUtc);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \CustomerManagement\StructType\NumberDatetimePair
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get TimestampUtc value
     * @return string
     */
    public function getTimestampUtc()
    {
        return $this->TimestampUtc;
    }
    /**
     * Set TimestampUtc value
     * @param string $timestampUtc
     * @return \CustomerManagement\StructType\NumberDatetimePair
     */
    public function setTimestampUtc($timestampUtc = null)
    {
        // validation for constraint: string
        if (!is_null($timestampUtc) && !is_string($timestampUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampUtc, true), gettype($timestampUtc)), __LINE__);
        }
        $this->TimestampUtc = $timestampUtc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\NumberDatetimePair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
