<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLoginInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfLoginInfo extends AbstractStructArrayBase
{
    /**
     * The LoginInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\LoginInfo[]
     */
    public $LoginInfo;
    /**
     * Constructor method for ArrayOfLoginInfo
     * @uses ArrayOfLoginInfo::setLoginInfo()
     * @param \CustomerManagement\StructType\LoginInfo[] $loginInfo
     */
    public function __construct(array $loginInfo = array())
    {
        $this
            ->setLoginInfo($loginInfo);
    }
    /**
     * Get LoginInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\LoginInfo[]|null
     */
    public function getLoginInfo()
    {
        return isset($this->LoginInfo) ? $this->LoginInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLoginInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoginInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoginInfoForArrayConstraintsFromSetLoginInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLoginInfoLoginInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfLoginInfoLoginInfoItem instanceof \CustomerManagement\StructType\LoginInfo) {
                $invalidValues[] = is_object($arrayOfLoginInfoLoginInfoItem) ? get_class($arrayOfLoginInfoLoginInfoItem) : sprintf('%s(%s)', gettype($arrayOfLoginInfoLoginInfoItem), var_export($arrayOfLoginInfoLoginInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoginInfo property can only contain items of type \CustomerManagement\StructType\LoginInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoginInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\LoginInfo[] $loginInfo
     * @return \CustomerManagement\ArrayType\ArrayOfLoginInfo
     */
    public function setLoginInfo(array $loginInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($loginInfoArrayErrorMessage = self::validateLoginInfoForArrayConstraintsFromSetLoginInfo($loginInfo))) {
            throw new \InvalidArgumentException($loginInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($loginInfo) || (is_array($loginInfo) && empty($loginInfo))) {
            unset($this->LoginInfo);
        } else {
            $this->LoginInfo = $loginInfo;
        }
        return $this;
    }
    /**
     * Add item to LoginInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\LoginInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfLoginInfo
     */
    public function addToLoginInfo(\CustomerManagement\StructType\LoginInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\LoginInfo) {
            throw new \InvalidArgumentException(sprintf('The LoginInfo property can only contain items of type \CustomerManagement\StructType\LoginInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoginInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\LoginInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\LoginInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\LoginInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\LoginInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\LoginInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LoginInfo
     */
    public function getAttributeName()
    {
        return 'LoginInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfLoginInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
