<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Phrase StructType
 * @subpackage Structs
 */
class Phrase extends AbstractStructBase
{
    /**
     * The FieldId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldId;
    /**
     * The FieldName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldName;
    /**
     * The FieldDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldDesc;
    /**
     * Constructor method for Phrase
     * @uses Phrase::setFieldId()
     * @uses Phrase::setFieldName()
     * @uses Phrase::setFieldDesc()
     * @param string $fieldId
     * @param string $fieldName
     * @param string $fieldDesc
     */
    public function __construct($fieldId = null, $fieldName = null, $fieldDesc = null)
    {
        $this
            ->setFieldId($fieldId)
            ->setFieldName($fieldName)
            ->setFieldDesc($fieldDesc);
    }
    /**
     * Get FieldId value
     * @return string|null
     */
    public function getFieldId()
    {
        return $this->FieldId;
    }
    /**
     * Set FieldId value
     * @param string $fieldId
     * @return \CustomerManagement\StructType\Phrase
     */
    public function setFieldId($fieldId = null)
    {
        // validation for constraint: string
        if (!is_null($fieldId) && !is_string($fieldId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldId, true), gettype($fieldId)), __LINE__);
        }
        $this->FieldId = $fieldId;
        return $this;
    }
    /**
     * Get FieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->FieldName;
    }
    /**
     * Set FieldName value
     * @param string $fieldName
     * @return \CustomerManagement\StructType\Phrase
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->FieldName = $fieldName;
        return $this;
    }
    /**
     * Get FieldDesc value
     * @return string|null
     */
    public function getFieldDesc()
    {
        return $this->FieldDesc;
    }
    /**
     * Set FieldDesc value
     * @param string $fieldDesc
     * @return \CustomerManagement\StructType\Phrase
     */
    public function setFieldDesc($fieldDesc = null)
    {
        // validation for constraint: string
        if (!is_null($fieldDesc) && !is_string($fieldDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldDesc, true), gettype($fieldDesc)), __LINE__);
        }
        $this->FieldDesc = $fieldDesc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\Phrase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
