<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for RRIRequestResultEnum EnumType
 * @subpackage Enumerations
 */
class RRIRequestResultEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'Busy'
     * @return string 'Busy'
     */
    const VALUE_BUSY = 'Busy';
    /**
     * Constant for value 'BadInputValue'
     * @return string 'BadInputValue'
     */
    const VALUE_BAD_INPUT_VALUE = 'BadInputValue';
    /**
     * Constant for value 'RequestLimitExceeded'
     * @return string 'RequestLimitExceeded'
     */
    const VALUE_REQUEST_LIMIT_EXCEEDED = 'RequestLimitExceeded';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_BUSY
     * @uses self::VALUE_BAD_INPUT_VALUE
     * @uses self::VALUE_REQUEST_LIMIT_EXCEEDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_SUCCESS,
            self::VALUE_BUSY,
            self::VALUE_BAD_INPUT_VALUE,
            self::VALUE_REQUEST_LIMIT_EXCEEDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
