<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vocabulary StructType
 * @subpackage Structs
 */
class Vocabulary extends AbstractStructBase
{
    /**
     * The VocabularyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VocabularyName;
    /**
     * The Phrases
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfPhrase
     */
    public $Phrases;
    /**
     * Constructor method for Vocabulary
     * @uses Vocabulary::setVocabularyName()
     * @uses Vocabulary::setPhrases()
     * @param string $vocabularyName
     * @param \CustomerManagement\ArrayType\ArrayOfPhrase $phrases
     */
    public function __construct($vocabularyName = null, \CustomerManagement\ArrayType\ArrayOfPhrase $phrases = null)
    {
        $this
            ->setVocabularyName($vocabularyName)
            ->setPhrases($phrases);
    }
    /**
     * Get VocabularyName value
     * @return string
     */
    public function getVocabularyName()
    {
        return $this->VocabularyName;
    }
    /**
     * Set VocabularyName value
     * @uses \CustomerManagement\EnumType\VocabularyNameEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\VocabularyNameEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vocabularyName
     * @return \CustomerManagement\StructType\Vocabulary
     */
    public function setVocabularyName($vocabularyName = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\VocabularyNameEnum::valueIsValid($vocabularyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\VocabularyNameEnum', is_array($vocabularyName) ? implode(', ', $vocabularyName) : var_export($vocabularyName, true), implode(', ', \CustomerManagement\EnumType\VocabularyNameEnum::getValidValues())), __LINE__);
        }
        $this->VocabularyName = $vocabularyName;
        return $this;
    }
    /**
     * Get Phrases value
     * @return \CustomerManagement\ArrayType\ArrayOfPhrase|null
     */
    public function getPhrases()
    {
        return $this->Phrases;
    }
    /**
     * Set Phrases value
     * @param \CustomerManagement\ArrayType\ArrayOfPhrase $phrases
     * @return \CustomerManagement\StructType\Vocabulary
     */
    public function setPhrases(\CustomerManagement\ArrayType\ArrayOfPhrase $phrases = null)
    {
        $this->Phrases = $phrases;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\Vocabulary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
