<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for CustomerInstallTypeEnum EnumType
 * @subpackage Enumerations
 */
class CustomerInstallTypeEnum
{
    /**
     * Constant for value 'ProfessionalInstall'
     * @return string 'ProfessionalInstall'
     */
    const VALUE_PROFESSIONAL_INSTALL = 'ProfessionalInstall';
    /**
     * Constant for value 'SelfInstall'
     * @return string 'SelfInstall'
     */
    const VALUE_SELF_INSTALL = 'SelfInstall';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PROFESSIONAL_INSTALL
     * @uses self::VALUE_SELF_INSTALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PROFESSIONAL_INSTALL,
            self::VALUE_SELF_INSTALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
