<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetImageSensorPartition StructType
 * @subpackage Structs
 */
class SetImageSensorPartition extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The deviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $deviceId;
    /**
     * The partitionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $partitionId;
    /**
     * The groupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $groupId;
    /**
     * Constructor method for SetImageSensorPartition
     * @uses SetImageSensorPartition::setCustomerId()
     * @uses SetImageSensorPartition::setDeviceId()
     * @uses SetImageSensorPartition::setPartitionId()
     * @uses SetImageSensorPartition::setGroupId()
     * @param int $customerId
     * @param int $deviceId
     * @param int $partitionId
     * @param int $groupId
     */
    public function __construct($customerId = null, $deviceId = null, $partitionId = null, $groupId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setPartitionId($partitionId)
            ->setGroupId($groupId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetImageSensorPartition
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get deviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->deviceId;
    }
    /**
     * Set deviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\SetImageSensorPartition
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->deviceId = $deviceId;
        return $this;
    }
    /**
     * Get partitionId value
     * @return int
     */
    public function getPartitionId()
    {
        return $this->partitionId;
    }
    /**
     * Set partitionId value
     * @param int $partitionId
     * @return \CustomerManagement\StructType\SetImageSensorPartition
     */
    public function setPartitionId($partitionId = null)
    {
        // validation for constraint: int
        if (!is_null($partitionId) && !(is_int($partitionId) || ctype_digit($partitionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partitionId, true), gettype($partitionId)), __LINE__);
        }
        $this->partitionId = $partitionId;
        return $this;
    }
    /**
     * Get groupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->groupId;
    }
    /**
     * Set groupId value
     * @param int $groupId
     * @return \CustomerManagement\StructType\SetImageSensorPartition
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !(is_int($groupId) || ctype_digit($groupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->groupId = $groupId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SetImageSensorPartition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
