<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for PanelSettingTypeEnum EnumType
 * @subpackage Enumerations
 */
class PanelSettingTypeEnum
{
    /**
     * Constant for value 'Number'
     * @return string 'Number'
     */
    const VALUE_NUMBER = 'Number';
    /**
     * Constant for value 'String'
     * @return string 'String'
     */
    const VALUE_STRING = 'String';
    /**
     * Constant for value 'Datetime'
     * @return string 'Datetime'
     */
    const VALUE_DATETIME = 'Datetime';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NUMBER
     * @uses self::VALUE_STRING
     * @uses self::VALUE_DATETIME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NUMBER,
            self::VALUE_STRING,
            self::VALUE_DATETIME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
