<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCameraInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfCameraInfo extends AbstractStructArrayBase
{
    /**
     * The CameraInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\CameraInfo[]
     */
    public $CameraInfo;
    /**
     * Constructor method for ArrayOfCameraInfo
     * @uses ArrayOfCameraInfo::setCameraInfo()
     * @param \CustomerManagement\StructType\CameraInfo[] $cameraInfo
     */
    public function __construct(array $cameraInfo = array())
    {
        $this
            ->setCameraInfo($cameraInfo);
    }
    /**
     * Get CameraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\CameraInfo[]|null
     */
    public function getCameraInfo()
    {
        return isset($this->CameraInfo) ? $this->CameraInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCameraInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCameraInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCameraInfoForArrayConstraintsFromSetCameraInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCameraInfoCameraInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCameraInfoCameraInfoItem instanceof \CustomerManagement\StructType\CameraInfo) {
                $invalidValues[] = is_object($arrayOfCameraInfoCameraInfoItem) ? get_class($arrayOfCameraInfoCameraInfoItem) : sprintf('%s(%s)', gettype($arrayOfCameraInfoCameraInfoItem), var_export($arrayOfCameraInfoCameraInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CameraInfo property can only contain items of type \CustomerManagement\StructType\CameraInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CameraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CameraInfo[] $cameraInfo
     * @return \CustomerManagement\ArrayType\ArrayOfCameraInfo
     */
    public function setCameraInfo(array $cameraInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($cameraInfoArrayErrorMessage = self::validateCameraInfoForArrayConstraintsFromSetCameraInfo($cameraInfo))) {
            throw new \InvalidArgumentException($cameraInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($cameraInfo) || (is_array($cameraInfo) && empty($cameraInfo))) {
            unset($this->CameraInfo);
        } else {
            $this->CameraInfo = $cameraInfo;
        }
        return $this;
    }
    /**
     * Add item to CameraInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CameraInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfCameraInfo
     */
    public function addToCameraInfo(\CustomerManagement\StructType\CameraInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\CameraInfo) {
            throw new \InvalidArgumentException(sprintf('The CameraInfo property can only contain items of type \CustomerManagement\StructType\CameraInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CameraInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\CameraInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\CameraInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\CameraInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\CameraInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\CameraInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CameraInfo
     */
    public function getAttributeName()
    {
        return 'CameraInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCameraInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
