<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for PanelNotRespondingStatusEnum EnumType
 * @subpackage Enumerations
 */
class PanelNotRespondingStatusEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Responding'
     * @return string 'Responding'
     */
    const VALUE_RESPONDING = 'Responding';
    /**
     * Constant for value 'NotResponding'
     * @return string 'NotResponding'
     */
    const VALUE_NOT_RESPONDING = 'NotResponding';
    /**
     * Constant for value 'ServerInitiatedPings'
     * @return string 'ServerInitiatedPings'
     */
    const VALUE_SERVER_INITIATED_PINGS = 'ServerInitiatedPings';
    /**
     * Constant for value 'NeverPinged'
     * @return string 'NeverPinged'
     */
    const VALUE_NEVER_PINGED = 'NeverPinged';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_RESPONDING
     * @uses self::VALUE_NOT_RESPONDING
     * @uses self::VALUE_SERVER_INITIATED_PINGS
     * @uses self::VALUE_NEVER_PINGED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_RESPONDING,
            self::VALUE_NOT_RESPONDING,
            self::VALUE_SERVER_INITIATED_PINGS,
            self::VALUE_NEVER_PINGED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
