<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CameraInfo StructType
 * @subpackage Structs
 */
class CameraInfo extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The InstallDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InstallDate;
    /**
     * The WirelessSignalStrength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WirelessSignalStrength;
    /**
     * The WifiLinkQuality
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $WifiLinkQuality;
    /**
     * The WifiSignalToNoiseRatio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WifiSignalToNoiseRatio;
    /**
     * The DeviceDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceDesc;
    /**
     * The DeviceModel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceModel;
    /**
     * The DeviceFirmware
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceFirmware;
    /**
     * The ExternalIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalIpAddress;
    /**
     * The VpnIp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VpnIp;
    /**
     * The Mac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mac;
    /**
     * The NormalizedWirelessSignalStrength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NormalizedWirelessSignalStrength;
    /**
     * Constructor method for CameraInfo
     * @uses CameraInfo::setDeviceId()
     * @uses CameraInfo::setInstallDate()
     * @uses CameraInfo::setWirelessSignalStrength()
     * @uses CameraInfo::setWifiLinkQuality()
     * @uses CameraInfo::setWifiSignalToNoiseRatio()
     * @uses CameraInfo::setDeviceDesc()
     * @uses CameraInfo::setDeviceModel()
     * @uses CameraInfo::setDeviceFirmware()
     * @uses CameraInfo::setExternalIpAddress()
     * @uses CameraInfo::setVpnIp()
     * @uses CameraInfo::setMac()
     * @uses CameraInfo::setNormalizedWirelessSignalStrength()
     * @param int $deviceId
     * @param string $installDate
     * @param int $wirelessSignalStrength
     * @param float $wifiLinkQuality
     * @param int $wifiSignalToNoiseRatio
     * @param string $deviceDesc
     * @param string $deviceModel
     * @param string $deviceFirmware
     * @param string $externalIpAddress
     * @param string $vpnIp
     * @param string $mac
     * @param string $normalizedWirelessSignalStrength
     */
    public function __construct($deviceId = null, $installDate = null, $wirelessSignalStrength = null, $wifiLinkQuality = null, $wifiSignalToNoiseRatio = null, $deviceDesc = null, $deviceModel = null, $deviceFirmware = null, $externalIpAddress = null, $vpnIp = null, $mac = null, $normalizedWirelessSignalStrength = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setInstallDate($installDate)
            ->setWirelessSignalStrength($wirelessSignalStrength)
            ->setWifiLinkQuality($wifiLinkQuality)
            ->setWifiSignalToNoiseRatio($wifiSignalToNoiseRatio)
            ->setDeviceDesc($deviceDesc)
            ->setDeviceModel($deviceModel)
            ->setDeviceFirmware($deviceFirmware)
            ->setExternalIpAddress($externalIpAddress)
            ->setVpnIp($vpnIp)
            ->setMac($mac)
            ->setNormalizedWirelessSignalStrength($normalizedWirelessSignalStrength);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get InstallDate value
     * @return string
     */
    public function getInstallDate()
    {
        return $this->InstallDate;
    }
    /**
     * Set InstallDate value
     * @param string $installDate
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setInstallDate($installDate = null)
    {
        // validation for constraint: string
        if (!is_null($installDate) && !is_string($installDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installDate, true), gettype($installDate)), __LINE__);
        }
        $this->InstallDate = $installDate;
        return $this;
    }
    /**
     * Get WirelessSignalStrength value
     * @return int
     */
    public function getWirelessSignalStrength()
    {
        return $this->WirelessSignalStrength;
    }
    /**
     * Set WirelessSignalStrength value
     * @param int $wirelessSignalStrength
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setWirelessSignalStrength($wirelessSignalStrength = null)
    {
        // validation for constraint: int
        if (!is_null($wirelessSignalStrength) && !(is_int($wirelessSignalStrength) || ctype_digit($wirelessSignalStrength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wirelessSignalStrength, true), gettype($wirelessSignalStrength)), __LINE__);
        }
        $this->WirelessSignalStrength = $wirelessSignalStrength;
        return $this;
    }
    /**
     * Get WifiLinkQuality value
     * @return float
     */
    public function getWifiLinkQuality()
    {
        return $this->WifiLinkQuality;
    }
    /**
     * Set WifiLinkQuality value
     * @param float $wifiLinkQuality
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setWifiLinkQuality($wifiLinkQuality = null)
    {
        // validation for constraint: float
        if (!is_null($wifiLinkQuality) && !(is_float($wifiLinkQuality) || is_numeric($wifiLinkQuality))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wifiLinkQuality, true), gettype($wifiLinkQuality)), __LINE__);
        }
        $this->WifiLinkQuality = $wifiLinkQuality;
        return $this;
    }
    /**
     * Get WifiSignalToNoiseRatio value
     * @return int
     */
    public function getWifiSignalToNoiseRatio()
    {
        return $this->WifiSignalToNoiseRatio;
    }
    /**
     * Set WifiSignalToNoiseRatio value
     * @param int $wifiSignalToNoiseRatio
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setWifiSignalToNoiseRatio($wifiSignalToNoiseRatio = null)
    {
        // validation for constraint: int
        if (!is_null($wifiSignalToNoiseRatio) && !(is_int($wifiSignalToNoiseRatio) || ctype_digit($wifiSignalToNoiseRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wifiSignalToNoiseRatio, true), gettype($wifiSignalToNoiseRatio)), __LINE__);
        }
        $this->WifiSignalToNoiseRatio = $wifiSignalToNoiseRatio;
        return $this;
    }
    /**
     * Get DeviceDesc value
     * @return string|null
     */
    public function getDeviceDesc()
    {
        return $this->DeviceDesc;
    }
    /**
     * Set DeviceDesc value
     * @param string $deviceDesc
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setDeviceDesc($deviceDesc = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDesc) && !is_string($deviceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceDesc, true), gettype($deviceDesc)), __LINE__);
        }
        $this->DeviceDesc = $deviceDesc;
        return $this;
    }
    /**
     * Get DeviceModel value
     * @return string|null
     */
    public function getDeviceModel()
    {
        return $this->DeviceModel;
    }
    /**
     * Set DeviceModel value
     * @param string $deviceModel
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setDeviceModel($deviceModel = null)
    {
        // validation for constraint: string
        if (!is_null($deviceModel) && !is_string($deviceModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceModel, true), gettype($deviceModel)), __LINE__);
        }
        $this->DeviceModel = $deviceModel;
        return $this;
    }
    /**
     * Get DeviceFirmware value
     * @return string|null
     */
    public function getDeviceFirmware()
    {
        return $this->DeviceFirmware;
    }
    /**
     * Set DeviceFirmware value
     * @param string $deviceFirmware
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setDeviceFirmware($deviceFirmware = null)
    {
        // validation for constraint: string
        if (!is_null($deviceFirmware) && !is_string($deviceFirmware)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceFirmware, true), gettype($deviceFirmware)), __LINE__);
        }
        $this->DeviceFirmware = $deviceFirmware;
        return $this;
    }
    /**
     * Get ExternalIpAddress value
     * @return string|null
     */
    public function getExternalIpAddress()
    {
        return $this->ExternalIpAddress;
    }
    /**
     * Set ExternalIpAddress value
     * @param string $externalIpAddress
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setExternalIpAddress($externalIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($externalIpAddress) && !is_string($externalIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalIpAddress, true), gettype($externalIpAddress)), __LINE__);
        }
        $this->ExternalIpAddress = $externalIpAddress;
        return $this;
    }
    /**
     * Get VpnIp value
     * @return string|null
     */
    public function getVpnIp()
    {
        return $this->VpnIp;
    }
    /**
     * Set VpnIp value
     * @param string $vpnIp
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setVpnIp($vpnIp = null)
    {
        // validation for constraint: string
        if (!is_null($vpnIp) && !is_string($vpnIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vpnIp, true), gettype($vpnIp)), __LINE__);
        }
        $this->VpnIp = $vpnIp;
        return $this;
    }
    /**
     * Get Mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->Mac;
    }
    /**
     * Set Mac value
     * @param string $mac
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mac, true), gettype($mac)), __LINE__);
        }
        $this->Mac = $mac;
        return $this;
    }
    /**
     * Get NormalizedWirelessSignalStrength value
     * @return string|null
     */
    public function getNormalizedWirelessSignalStrength()
    {
        return $this->NormalizedWirelessSignalStrength;
    }
    /**
     * Set NormalizedWirelessSignalStrength value
     * @param string $normalizedWirelessSignalStrength
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public function setNormalizedWirelessSignalStrength($normalizedWirelessSignalStrength = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedWirelessSignalStrength) && !is_string($normalizedWirelessSignalStrength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedWirelessSignalStrength, true), gettype($normalizedWirelessSignalStrength)), __LINE__);
        }
        $this->NormalizedWirelessSignalStrength = $normalizedWirelessSignalStrength;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CameraInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
