<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateLoginPasswordInput StructType
 * @subpackage Structs
 */
class ValidateLoginPasswordInput extends AbstractStructBase
{
    /**
     * The RecordAsLoginEvent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RecordAsLoginEvent;
    /**
     * The CallerVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallerVersion;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for ValidateLoginPasswordInput
     * @uses ValidateLoginPasswordInput::setRecordAsLoginEvent()
     * @uses ValidateLoginPasswordInput::setCallerVersion()
     * @uses ValidateLoginPasswordInput::setLoginName()
     * @uses ValidateLoginPasswordInput::setPassword()
     * @param bool $recordAsLoginEvent
     * @param int $callerVersion
     * @param string $loginName
     * @param string $password
     */
    public function __construct($recordAsLoginEvent = null, $callerVersion = null, $loginName = null, $password = null)
    {
        $this
            ->setRecordAsLoginEvent($recordAsLoginEvent)
            ->setCallerVersion($callerVersion)
            ->setLoginName($loginName)
            ->setPassword($password);
    }
    /**
     * Get RecordAsLoginEvent value
     * @return bool
     */
    public function getRecordAsLoginEvent()
    {
        return $this->RecordAsLoginEvent;
    }
    /**
     * Set RecordAsLoginEvent value
     * @param bool $recordAsLoginEvent
     * @return \CustomerManagement\StructType\ValidateLoginPasswordInput
     */
    public function setRecordAsLoginEvent($recordAsLoginEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($recordAsLoginEvent) && !is_bool($recordAsLoginEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recordAsLoginEvent, true), gettype($recordAsLoginEvent)), __LINE__);
        }
        $this->RecordAsLoginEvent = $recordAsLoginEvent;
        return $this;
    }
    /**
     * Get CallerVersion value
     * @return int
     */
    public function getCallerVersion()
    {
        return $this->CallerVersion;
    }
    /**
     * Set CallerVersion value
     * @param int $callerVersion
     * @return \CustomerManagement\StructType\ValidateLoginPasswordInput
     */
    public function setCallerVersion($callerVersion = null)
    {
        // validation for constraint: int
        if (!is_null($callerVersion) && !(is_int($callerVersion) || ctype_digit($callerVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callerVersion, true), gettype($callerVersion)), __LINE__);
        }
        $this->CallerVersion = $callerVersion;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\ValidateLoginPasswordInput
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \CustomerManagement\StructType\ValidateLoginPasswordInput
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ValidateLoginPasswordInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
