<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelSettingInput StructType
 * @subpackage Structs
 */
class PanelSettingInput extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The PanelSettingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelSettingId;
    /**
     * The NewValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewValue;
    /**
     * Constructor method for PanelSettingInput
     * @uses PanelSettingInput::setDeviceId()
     * @uses PanelSettingInput::setPanelSettingId()
     * @uses PanelSettingInput::setNewValue()
     * @param int $deviceId
     * @param int $panelSettingId
     * @param string $newValue
     */
    public function __construct($deviceId = null, $panelSettingId = null, $newValue = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setPanelSettingId($panelSettingId)
            ->setNewValue($newValue);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\PanelSettingInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get PanelSettingId value
     * @return int
     */
    public function getPanelSettingId()
    {
        return $this->PanelSettingId;
    }
    /**
     * Set PanelSettingId value
     * @param int $panelSettingId
     * @return \CustomerManagement\StructType\PanelSettingInput
     */
    public function setPanelSettingId($panelSettingId = null)
    {
        // validation for constraint: int
        if (!is_null($panelSettingId) && !(is_int($panelSettingId) || ctype_digit($panelSettingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelSettingId, true), gettype($panelSettingId)), __LINE__);
        }
        $this->PanelSettingId = $panelSettingId;
        return $this;
    }
    /**
     * Get NewValue value
     * @return string|null
     */
    public function getNewValue()
    {
        return $this->NewValue;
    }
    /**
     * Set NewValue value
     * @param string $newValue
     * @return \CustomerManagement\StructType\PanelSettingInput
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newValue, true), gettype($newValue)), __LINE__);
        }
        $this->NewValue = $newValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\PanelSettingInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
