<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSolarDataOutput StructType
 * @subpackage Structs
 */
class GetSolarDataOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The EnergyGenerated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EnergyGenerated;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetSolarDataOutput
     * @uses GetSolarDataOutput::setSuccess()
     * @uses GetSolarDataOutput::setEnergyGenerated()
     * @uses GetSolarDataOutput::setErrorMessage()
     * @param bool $success
     * @param float $energyGenerated
     * @param string $errorMessage
     */
    public function __construct($success = null, $energyGenerated = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setEnergyGenerated($energyGenerated)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetSolarDataOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get EnergyGenerated value
     * @return float
     */
    public function getEnergyGenerated()
    {
        return $this->EnergyGenerated;
    }
    /**
     * Set EnergyGenerated value
     * @param float $energyGenerated
     * @return \CustomerManagement\StructType\GetSolarDataOutput
     */
    public function setEnergyGenerated($energyGenerated = null)
    {
        // validation for constraint: float
        if (!is_null($energyGenerated) && !(is_float($energyGenerated) || is_numeric($energyGenerated))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($energyGenerated, true), gettype($energyGenerated)), __LINE__);
        }
        $this->EnergyGenerated = $energyGenerated;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetSolarDataOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetSolarDataOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
