<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLastPanelDateInput StructType
 * @subpackage Structs
 */
class GetLastPanelDateInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The PanelDateType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelDateType;
    /**
     * Constructor method for GetLastPanelDateInput
     * @uses GetLastPanelDateInput::setCustomerId()
     * @uses GetLastPanelDateInput::setPanelDateType()
     * @param int $customerId
     * @param string $panelDateType
     */
    public function __construct($customerId = null, $panelDateType = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPanelDateType($panelDateType);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\GetLastPanelDateInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get PanelDateType value
     * @return string
     */
    public function getPanelDateType()
    {
        return $this->PanelDateType;
    }
    /**
     * Set PanelDateType value
     * @uses \CustomerManagement\EnumType\PanelDateType::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelDateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelDateType
     * @return \CustomerManagement\StructType\GetLastPanelDateInput
     */
    public function setPanelDateType($panelDateType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelDateType::valueIsValid($panelDateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelDateType', is_array($panelDateType) ? implode(', ', $panelDateType) : var_export($panelDateType, true), implode(', ', \CustomerManagement\EnumType\PanelDateType::getValidValues())), __LINE__);
        }
        $this->PanelDateType = $panelDateType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetLastPanelDateInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
