<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivateCommitmentInput StructType
 * @subpackage Structs
 */
class ActivateCommitmentInput extends AbstractStructBase
{
    /**
     * The CommitmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommitmentId;
    /**
     * The PanelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PanelType;
    /**
     * The IgnoreLowCoverageErrors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IgnoreLowCoverageErrors;
    /**
     * The IsInstalledByExpectedInstaller
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInstalledByExpectedInstaller;
    /**
     * The UsingADCApp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UsingADCApp;
    /**
     * The ModemSerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemSerialNumber;
    /**
     * Constructor method for ActivateCommitmentInput
     * @uses ActivateCommitmentInput::setCommitmentId()
     * @uses ActivateCommitmentInput::setPanelType()
     * @uses ActivateCommitmentInput::setIgnoreLowCoverageErrors()
     * @uses ActivateCommitmentInput::setIsInstalledByExpectedInstaller()
     * @uses ActivateCommitmentInput::setUsingADCApp()
     * @uses ActivateCommitmentInput::setModemSerialNumber()
     * @param int $commitmentId
     * @param string $panelType
     * @param bool $ignoreLowCoverageErrors
     * @param bool $isInstalledByExpectedInstaller
     * @param bool $usingADCApp
     * @param string $modemSerialNumber
     */
    public function __construct($commitmentId = null, $panelType = null, $ignoreLowCoverageErrors = null, $isInstalledByExpectedInstaller = null, $usingADCApp = null, $modemSerialNumber = null)
    {
        $this
            ->setCommitmentId($commitmentId)
            ->setPanelType($panelType)
            ->setIgnoreLowCoverageErrors($ignoreLowCoverageErrors)
            ->setIsInstalledByExpectedInstaller($isInstalledByExpectedInstaller)
            ->setUsingADCApp($usingADCApp)
            ->setModemSerialNumber($modemSerialNumber);
    }
    /**
     * Get CommitmentId value
     * @return int
     */
    public function getCommitmentId()
    {
        return $this->CommitmentId;
    }
    /**
     * Set CommitmentId value
     * @param int $commitmentId
     * @return \CustomerManagement\StructType\ActivateCommitmentInput
     */
    public function setCommitmentId($commitmentId = null)
    {
        // validation for constraint: int
        if (!is_null($commitmentId) && !(is_int($commitmentId) || ctype_digit($commitmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($commitmentId, true), gettype($commitmentId)), __LINE__);
        }
        $this->CommitmentId = $commitmentId;
        return $this;
    }
    /**
     * Get PanelType value
     * @return string
     */
    public function getPanelType()
    {
        return $this->PanelType;
    }
    /**
     * Set PanelType value
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $panelType
     * @return \CustomerManagement\StructType\ActivateCommitmentInput
     */
    public function setPanelType($panelType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelTypeEnum::valueIsValid($panelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PanelTypeEnum', is_array($panelType) ? implode(', ', $panelType) : var_export($panelType, true), implode(', ', \CustomerManagement\EnumType\PanelTypeEnum::getValidValues())), __LINE__);
        }
        $this->PanelType = $panelType;
        return $this;
    }
    /**
     * Get IgnoreLowCoverageErrors value
     * @return bool
     */
    public function getIgnoreLowCoverageErrors()
    {
        return $this->IgnoreLowCoverageErrors;
    }
    /**
     * Set IgnoreLowCoverageErrors value
     * @param bool $ignoreLowCoverageErrors
     * @return \CustomerManagement\StructType\ActivateCommitmentInput
     */
    public function setIgnoreLowCoverageErrors($ignoreLowCoverageErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreLowCoverageErrors) && !is_bool($ignoreLowCoverageErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreLowCoverageErrors, true), gettype($ignoreLowCoverageErrors)), __LINE__);
        }
        $this->IgnoreLowCoverageErrors = $ignoreLowCoverageErrors;
        return $this;
    }
    /**
     * Get IsInstalledByExpectedInstaller value
     * @return bool
     */
    public function getIsInstalledByExpectedInstaller()
    {
        return $this->IsInstalledByExpectedInstaller;
    }
    /**
     * Set IsInstalledByExpectedInstaller value
     * @param bool $isInstalledByExpectedInstaller
     * @return \CustomerManagement\StructType\ActivateCommitmentInput
     */
    public function setIsInstalledByExpectedInstaller($isInstalledByExpectedInstaller = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInstalledByExpectedInstaller) && !is_bool($isInstalledByExpectedInstaller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInstalledByExpectedInstaller, true), gettype($isInstalledByExpectedInstaller)), __LINE__);
        }
        $this->IsInstalledByExpectedInstaller = $isInstalledByExpectedInstaller;
        return $this;
    }
    /**
     * Get UsingADCApp value
     * @return bool
     */
    public function getUsingADCApp()
    {
        return $this->UsingADCApp;
    }
    /**
     * Set UsingADCApp value
     * @param bool $usingADCApp
     * @return \CustomerManagement\StructType\ActivateCommitmentInput
     */
    public function setUsingADCApp($usingADCApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($usingADCApp) && !is_bool($usingADCApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usingADCApp, true), gettype($usingADCApp)), __LINE__);
        }
        $this->UsingADCApp = $usingADCApp;
        return $this;
    }
    /**
     * Get ModemSerialNumber value
     * @return string|null
     */
    public function getModemSerialNumber()
    {
        return $this->ModemSerialNumber;
    }
    /**
     * Set ModemSerialNumber value
     * @param string $modemSerialNumber
     * @return \CustomerManagement\StructType\ActivateCommitmentInput
     */
    public function setModemSerialNumber($modemSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($modemSerialNumber) && !is_string($modemSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modemSerialNumber, true), gettype($modemSerialNumber)), __LINE__);
        }
        $this->ModemSerialNumber = $modemSerialNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ActivateCommitmentInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
