<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemGroupInfo StructType
 * @subpackage Structs
 */
class SystemGroupInfo extends AbstractStructBase
{
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupId;
    /**
     * The SubGroupIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $SubGroupIds;
    /**
     * The LoginRole
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginRole;
    /**
     * Constructor method for SystemGroupInfo
     * @uses SystemGroupInfo::setGroupId()
     * @uses SystemGroupInfo::setSubGroupIds()
     * @uses SystemGroupInfo::setLoginRole()
     * @param int $groupId
     * @param \CustomerManagement\ArrayType\ArrayOfInt $subGroupIds
     * @param string $loginRole
     */
    public function __construct($groupId = null, \CustomerManagement\ArrayType\ArrayOfInt $subGroupIds = null, $loginRole = null)
    {
        $this
            ->setGroupId($groupId)
            ->setSubGroupIds($subGroupIds)
            ->setLoginRole($loginRole);
    }
    /**
     * Get GroupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \CustomerManagement\StructType\SystemGroupInfo
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !(is_int($groupId) || ctype_digit($groupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get SubGroupIds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getSubGroupIds()
    {
        return $this->SubGroupIds;
    }
    /**
     * Set SubGroupIds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $subGroupIds
     * @return \CustomerManagement\StructType\SystemGroupInfo
     */
    public function setSubGroupIds(\CustomerManagement\ArrayType\ArrayOfInt $subGroupIds = null)
    {
        $this->SubGroupIds = $subGroupIds;
        return $this;
    }
    /**
     * Get LoginRole value
     * @return string|null
     */
    public function getLoginRole()
    {
        return $this->LoginRole;
    }
    /**
     * Set LoginRole value
     * @param string $loginRole
     * @return \CustomerManagement\StructType\SystemGroupInfo
     */
    public function setLoginRole($loginRole = null)
    {
        // validation for constraint: string
        if (!is_null($loginRole) && !is_string($loginRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginRole, true), gettype($loginRole)), __LINE__);
        }
        $this->LoginRole = $loginRole;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SystemGroupInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
