<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for CustomerNotificationEnum EnumType
 * @subpackage Enumerations
 */
class CustomerNotificationEnum
{
    /**
     * Constant for value 'Alarms'
     * @return string 'Alarms'
     */
    const VALUE_ALARMS = 'Alarms';
    /**
     * Constant for value 'Arming'
     * @return string 'Arming'
     */
    const VALUE_ARMING = 'Arming';
    /**
     * Constant for value 'Disarming'
     * @return string 'Disarming'
     */
    const VALUE_DISARMING = 'Disarming';
    /**
     * Constant for value 'PowerFailure'
     * @return string 'PowerFailure'
     */
    const VALUE_POWER_FAILURE = 'PowerFailure';
    /**
     * Constant for value 'PowerRestored'
     * @return string 'PowerRestored'
     */
    const VALUE_POWER_RESTORED = 'PowerRestored';
    /**
     * Constant for value 'LowBattery'
     * @return string 'LowBattery'
     */
    const VALUE_LOW_BATTERY = 'LowBattery';
    /**
     * Constant for value 'Bypassed'
     * @return string 'Bypassed'
     */
    const VALUE_BYPASSED = 'Bypassed';
    /**
     * Constant for value 'Tamper'
     * @return string 'Tamper'
     */
    const VALUE_TAMPER = 'Tamper';
    /**
     * Constant for value 'Malfunction'
     * @return string 'Malfunction'
     */
    const VALUE_MALFUNCTION = 'Malfunction';
    /**
     * Constant for value 'CameraNotResponding'
     * @return string 'CameraNotResponding'
     */
    const VALUE_CAMERA_NOT_RESPONDING = 'CameraNotResponding';
    /**
     * Constant for value 'CameraUploadLimits'
     * @return string 'CameraUploadLimits'
     */
    const VALUE_CAMERA_UPLOAD_LIMITS = 'CameraUploadLimits';
    /**
     * Constant for value 'SmsOverQuota'
     * @return string 'SmsOverQuota'
     */
    const VALUE_SMS_OVER_QUOTA = 'SmsOverQuota';
    /**
     * Constant for value 'PanelNotResponding'
     * @return string 'PanelNotResponding'
     */
    const VALUE_PANEL_NOT_RESPONDING = 'PanelNotResponding';
    /**
     * Constant for value 'ArmingReminder'
     * @return string 'ArmingReminder'
     */
    const VALUE_ARMING_REMINDER = 'ArmingReminder';
    /**
     * Constant for value 'Insights'
     * @return string 'Insights'
     */
    const VALUE_INSIGHTS = 'Insights';
    /**
     * Constant for value 'TroubleSensorTriggered'
     * @return string 'TroubleSensorTriggered'
     */
    const VALUE_TROUBLE_SENSOR_TRIGGERED = 'TroubleSensorTriggered';
    /**
     * Constant for value 'HVACHealthReport'
     * @return string 'HVACHealthReport'
     */
    const VALUE_HVACHEALTH_REPORT = 'HVACHealthReport';
    /**
     * Constant for value 'SeasonalMaintenance'
     * @return string 'SeasonalMaintenance'
     */
    const VALUE_SEASONAL_MAINTENANCE = 'SeasonalMaintenance';
    /**
     * Constant for value 'COSensorOpened'
     * @return string 'COSensorOpened'
     */
    const VALUE_COSENSOR_OPENED = 'COSensorOpened';
    /**
     * Constant for value 'TemperatureSensorOpened'
     * @return string 'TemperatureSensorOpened'
     */
    const VALUE_TEMPERATURE_SENSOR_OPENED = 'TemperatureSensorOpened';
    /**
     * Constant for value 'SensorActivated'
     * @return string 'SensorActivated'
     */
    const VALUE_SENSOR_ACTIVATED = 'SensorActivated';
    /**
     * Constant for value 'HeatingCoolingAlert'
     * @return string 'HeatingCoolingAlert'
     */
    const VALUE_HEATING_COOLING_ALERT = 'HeatingCoolingAlert';
    /**
     * Constant for value 'LockKeypadDisabledTooManyTries'
     * @return string 'LockKeypadDisabledTooManyTries'
     */
    const VALUE_LOCK_KEYPAD_DISABLED_TOO_MANY_TRIES = 'LockKeypadDisabledTooManyTries';
    /**
     * Constant for value 'LockCannotBeSecured'
     * @return string 'LockCannotBeSecured'
     */
    const VALUE_LOCK_CANNOT_BE_SECURED = 'LockCannotBeSecured';
    /**
     * Constant for value 'WaterMeterLeakAlert'
     * @return string 'WaterMeterLeakAlert'
     */
    const VALUE_WATER_METER_LEAK_ALERT = 'WaterMeterLeakAlert';
    /**
     * Constant for value 'DoorActivity'
     * @return string 'DoorActivity'
     */
    const VALUE_DOOR_ACTIVITY = 'DoorActivity';
    /**
     * Constant for value 'AccessControlRuleFailed'
     * @return string 'AccessControlRuleFailed'
     */
    const VALUE_ACCESS_CONTROL_RULE_FAILED = 'AccessControlRuleFailed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALARMS
     * @uses self::VALUE_ARMING
     * @uses self::VALUE_DISARMING
     * @uses self::VALUE_POWER_FAILURE
     * @uses self::VALUE_POWER_RESTORED
     * @uses self::VALUE_LOW_BATTERY
     * @uses self::VALUE_BYPASSED
     * @uses self::VALUE_TAMPER
     * @uses self::VALUE_MALFUNCTION
     * @uses self::VALUE_CAMERA_NOT_RESPONDING
     * @uses self::VALUE_CAMERA_UPLOAD_LIMITS
     * @uses self::VALUE_SMS_OVER_QUOTA
     * @uses self::VALUE_PANEL_NOT_RESPONDING
     * @uses self::VALUE_ARMING_REMINDER
     * @uses self::VALUE_INSIGHTS
     * @uses self::VALUE_TROUBLE_SENSOR_TRIGGERED
     * @uses self::VALUE_HVACHEALTH_REPORT
     * @uses self::VALUE_SEASONAL_MAINTENANCE
     * @uses self::VALUE_COSENSOR_OPENED
     * @uses self::VALUE_TEMPERATURE_SENSOR_OPENED
     * @uses self::VALUE_SENSOR_ACTIVATED
     * @uses self::VALUE_HEATING_COOLING_ALERT
     * @uses self::VALUE_LOCK_KEYPAD_DISABLED_TOO_MANY_TRIES
     * @uses self::VALUE_LOCK_CANNOT_BE_SECURED
     * @uses self::VALUE_WATER_METER_LEAK_ALERT
     * @uses self::VALUE_DOOR_ACTIVITY
     * @uses self::VALUE_ACCESS_CONTROL_RULE_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALARMS,
            self::VALUE_ARMING,
            self::VALUE_DISARMING,
            self::VALUE_POWER_FAILURE,
            self::VALUE_POWER_RESTORED,
            self::VALUE_LOW_BATTERY,
            self::VALUE_BYPASSED,
            self::VALUE_TAMPER,
            self::VALUE_MALFUNCTION,
            self::VALUE_CAMERA_NOT_RESPONDING,
            self::VALUE_CAMERA_UPLOAD_LIMITS,
            self::VALUE_SMS_OVER_QUOTA,
            self::VALUE_PANEL_NOT_RESPONDING,
            self::VALUE_ARMING_REMINDER,
            self::VALUE_INSIGHTS,
            self::VALUE_TROUBLE_SENSOR_TRIGGERED,
            self::VALUE_HVACHEALTH_REPORT,
            self::VALUE_SEASONAL_MAINTENANCE,
            self::VALUE_COSENSOR_OPENED,
            self::VALUE_TEMPERATURE_SENSOR_OPENED,
            self::VALUE_SENSOR_ACTIVATED,
            self::VALUE_HEATING_COOLING_ALERT,
            self::VALUE_LOCK_KEYPAD_DISABLED_TOO_MANY_TRIES,
            self::VALUE_LOCK_CANNOT_BE_SECURED,
            self::VALUE_WATER_METER_LEAK_ALERT,
            self::VALUE_DOOR_ACTIVITY,
            self::VALUE_ACCESS_CONTROL_RULE_FAILED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
