<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for CountryEnum EnumType
 * @subpackage Enumerations
 */
class CountryEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'USA'
     * @return string 'USA'
     */
    const VALUE_USA = 'USA';
    /**
     * Constant for value 'Canada'
     * @return string 'Canada'
     */
    const VALUE_CANADA = 'Canada';
    /**
     * Constant for value 'Brazil'
     * @return string 'Brazil'
     */
    const VALUE_BRAZIL = 'Brazil';
    /**
     * Constant for value 'Mexico'
     * @return string 'Mexico'
     */
    const VALUE_MEXICO = 'Mexico';
    /**
     * Constant for value 'SouthAfrica'
     * @return string 'SouthAfrica'
     */
    const VALUE_SOUTH_AFRICA = 'SouthAfrica';
    /**
     * Constant for value 'Chile'
     * @return string 'Chile'
     */
    const VALUE_CHILE = 'Chile';
    /**
     * Constant for value 'Argentina'
     * @return string 'Argentina'
     */
    const VALUE_ARGENTINA = 'Argentina';
    /**
     * Constant for value 'Colombia'
     * @return string 'Colombia'
     */
    const VALUE_COLOMBIA = 'Colombia';
    /**
     * Constant for value 'NewZealand'
     * @return string 'NewZealand'
     */
    const VALUE_NEW_ZEALAND = 'NewZealand';
    /**
     * Constant for value 'Turkey'
     * @return string 'Turkey'
     */
    const VALUE_TURKEY = 'Turkey';
    /**
     * Constant for value 'Botswana'
     * @return string 'Botswana'
     */
    const VALUE_BOTSWANA = 'Botswana';
    /**
     * Constant for value 'Panama'
     * @return string 'Panama'
     */
    const VALUE_PANAMA = 'Panama';
    /**
     * Constant for value 'CostaRica'
     * @return string 'CostaRica'
     */
    const VALUE_COSTA_RICA = 'CostaRica';
    /**
     * Constant for value 'Venezuela'
     * @return string 'Venezuela'
     */
    const VALUE_VENEZUELA = 'Venezuela';
    /**
     * Constant for value 'DominicanRepublic'
     * @return string 'DominicanRepublic'
     */
    const VALUE_DOMINICAN_REPUBLIC = 'DominicanRepublic';
    /**
     * Constant for value 'Ecuador'
     * @return string 'Ecuador'
     */
    const VALUE_ECUADOR = 'Ecuador';
    /**
     * Constant for value 'Guatemala'
     * @return string 'Guatemala'
     */
    const VALUE_GUATEMALA = 'Guatemala';
    /**
     * Constant for value 'Peru'
     * @return string 'Peru'
     */
    const VALUE_PERU = 'Peru';
    /**
     * Constant for value 'Honduras'
     * @return string 'Honduras'
     */
    const VALUE_HONDURAS = 'Honduras';
    /**
     * Constant for value 'TrinidadTobago'
     * @return string 'TrinidadTobago'
     */
    const VALUE_TRINIDAD_TOBAGO = 'TrinidadTobago';
    /**
     * Constant for value 'Australia'
     * @return string 'Australia'
     */
    const VALUE_AUSTRALIA = 'Australia';
    /**
     * Constant for value 'Jamaica'
     * @return string 'Jamaica'
     */
    const VALUE_JAMAICA = 'Jamaica';
    /**
     * Constant for value 'Bahamas'
     * @return string 'Bahamas'
     */
    const VALUE_BAHAMAS = 'Bahamas';
    /**
     * Constant for value 'SaintKittsNevis'
     * @return string 'SaintKittsNevis'
     */
    const VALUE_SAINT_KITTS_NEVIS = 'SaintKittsNevis';
    /**
     * Constant for value 'Barbados'
     * @return string 'Barbados'
     */
    const VALUE_BARBADOS = 'Barbados';
    /**
     * Constant for value 'Ghana'
     * @return string 'Ghana'
     */
    const VALUE_GHANA = 'Ghana';
    /**
     * Constant for value 'Spain'
     * @return string 'Spain'
     */
    const VALUE_SPAIN = 'Spain';
    /**
     * Constant for value 'Portugal'
     * @return string 'Portugal'
     */
    const VALUE_PORTUGAL = 'Portugal';
    /**
     * Constant for value 'Uruguay'
     * @return string 'Uruguay'
     */
    const VALUE_URUGUAY = 'Uruguay';
    /**
     * Constant for value 'Paraguay'
     * @return string 'Paraguay'
     */
    const VALUE_PARAGUAY = 'Paraguay';
    /**
     * Constant for value 'HongKong'
     * @return string 'HongKong'
     */
    const VALUE_HONG_KONG = 'HongKong';
    /**
     * Constant for value 'Bolivia'
     * @return string 'Bolivia'
     */
    const VALUE_BOLIVIA = 'Bolivia';
    /**
     * Constant for value 'Nigeria'
     * @return string 'Nigeria'
     */
    const VALUE_NIGERIA = 'Nigeria';
    /**
     * Constant for value 'Bermuda'
     * @return string 'Bermuda'
     */
    const VALUE_BERMUDA = 'Bermuda';
    /**
     * Constant for value 'USVirginIslands'
     * @return string 'USVirginIslands'
     */
    const VALUE_USVIRGIN_ISLANDS = 'USVirginIslands';
    /**
     * Constant for value 'Nicaragua'
     * @return string 'Nicaragua'
     */
    const VALUE_NICARAGUA = 'Nicaragua';
    /**
     * Constant for value 'ElSalvador'
     * @return string 'ElSalvador'
     */
    const VALUE_EL_SALVADOR = 'ElSalvador';
    /**
     * Constant for value 'India'
     * @return string 'India'
     */
    const VALUE_INDIA = 'India';
    /**
     * Constant for value 'TurksCaicos'
     * @return string 'TurksCaicos'
     */
    const VALUE_TURKS_CAICOS = 'TurksCaicos';
    /**
     * Constant for value 'UnitedKingdom'
     * @return string 'UnitedKingdom'
     */
    const VALUE_UNITED_KINGDOM = 'UnitedKingdom';
    /**
     * Constant for value 'Mozambique'
     * @return string 'Mozambique'
     */
    const VALUE_MOZAMBIQUE = 'Mozambique';
    /**
     * Constant for value 'Netherlands'
     * @return string 'Netherlands'
     */
    const VALUE_NETHERLANDS = 'Netherlands';
    /**
     * Constant for value 'Belgium'
     * @return string 'Belgium'
     */
    const VALUE_BELGIUM = 'Belgium';
    /**
     * Constant for value 'Sweden'
     * @return string 'Sweden'
     */
    const VALUE_SWEDEN = 'Sweden';
    /**
     * Constant for value 'Switzerland'
     * @return string 'Switzerland'
     */
    const VALUE_SWITZERLAND = 'Switzerland';
    /**
     * Constant for value 'Poland'
     * @return string 'Poland'
     */
    const VALUE_POLAND = 'Poland';
    /**
     * Constant for value 'Thailand'
     * @return string 'Thailand'
     */
    const VALUE_THAILAND = 'Thailand';
    /**
     * Constant for value 'Fiji'
     * @return string 'Fiji'
     */
    const VALUE_FIJI = 'Fiji';
    /**
     * Constant for value 'Ireland'
     * @return string 'Ireland'
     */
    const VALUE_IRELAND = 'Ireland';
    /**
     * Constant for value 'Malaysia'
     * @return string 'Malaysia'
     */
    const VALUE_MALAYSIA = 'Malaysia';
    /**
     * Constant for value 'Denmark'
     * @return string 'Denmark'
     */
    const VALUE_DENMARK = 'Denmark';
    /**
     * Constant for value 'Norway'
     * @return string 'Norway'
     */
    const VALUE_NORWAY = 'Norway';
    /**
     * Constant for value 'BritishVirginIslands'
     * @return string 'BritishVirginIslands'
     */
    const VALUE_BRITISH_VIRGIN_ISLANDS = 'BritishVirginIslands';
    /**
     * Constant for value 'CaymanIslands'
     * @return string 'CaymanIslands'
     */
    const VALUE_CAYMAN_ISLANDS = 'CaymanIslands';
    /**
     * Constant for value 'France'
     * @return string 'France'
     */
    const VALUE_FRANCE = 'France';
    /**
     * Constant for value 'Taiwan'
     * @return string 'Taiwan'
     */
    const VALUE_TAIWAN = 'Taiwan';
    /**
     * Constant for value 'China'
     * @return string 'China'
     */
    const VALUE_CHINA = 'China';
    /**
     * Constant for value 'Philippines'
     * @return string 'Philippines'
     */
    const VALUE_PHILIPPINES = 'Philippines';
    /**
     * Constant for value 'Cyprus'
     * @return string 'Cyprus'
     */
    const VALUE_CYPRUS = 'Cyprus';
    /**
     * Constant for value 'SaudiArabia'
     * @return string 'SaudiArabia'
     */
    const VALUE_SAUDI_ARABIA = 'SaudiArabia';
    /**
     * Constant for value 'Iceland'
     * @return string 'Iceland'
     */
    const VALUE_ICELAND = 'Iceland';
    /**
     * Constant for value 'Israel'
     * @return string 'Israel'
     */
    const VALUE_ISRAEL = 'Israel';
    /**
     * Constant for value 'Singapore'
     * @return string 'Singapore'
     */
    const VALUE_SINGAPORE = 'Singapore';
    /**
     * Constant for value 'Luxembourg'
     * @return string 'Luxembourg'
     */
    const VALUE_LUXEMBOURG = 'Luxembourg';
    /**
     * Constant for value 'UnitedArabEmirates'
     * @return string 'UnitedArabEmirates'
     */
    const VALUE_UNITED_ARAB_EMIRATES = 'UnitedArabEmirates';
    /**
     * Constant for value 'Malta'
     * @return string 'Malta'
     */
    const VALUE_MALTA = 'Malta';
    /**
     * Constant for value 'Greece'
     * @return string 'Greece'
     */
    const VALUE_GREECE = 'Greece';
    /**
     * Constant for value 'Guyana'
     * @return string 'Guyana'
     */
    const VALUE_GUYANA = 'Guyana';
    /**
     * Constant for value 'Croatia'
     * @return string 'Croatia'
     */
    const VALUE_CROATIA = 'Croatia';
    /**
     * Constant for value 'Japan'
     * @return string 'Japan'
     */
    const VALUE_JAPAN = 'Japan';
    /**
     * Constant for value 'Dominica'
     * @return string 'Dominica'
     */
    const VALUE_DOMINICA = 'Dominica';
    /**
     * Constant for value 'Belize'
     * @return string 'Belize'
     */
    const VALUE_BELIZE = 'Belize';
    /**
     * Constant for value 'Finland'
     * @return string 'Finland'
     */
    const VALUE_FINLAND = 'Finland';
    /**
     * Constant for value 'Germany'
     * @return string 'Germany'
     */
    const VALUE_GERMANY = 'Germany';
    /**
     * Constant for value 'StLucia'
     * @return string 'StLucia'
     */
    const VALUE_ST_LUCIA = 'StLucia';
    /**
     * Constant for value 'Grenada'
     * @return string 'Grenada'
     */
    const VALUE_GRENADA = 'Grenada';
    /**
     * Constant for value 'Indonesia'
     * @return string 'Indonesia'
     */
    const VALUE_INDONESIA = 'Indonesia';
    /**
     * Constant for value 'Bahrain'
     * @return string 'Bahrain'
     */
    const VALUE_BAHRAIN = 'Bahrain';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_USA
     * @uses self::VALUE_CANADA
     * @uses self::VALUE_BRAZIL
     * @uses self::VALUE_MEXICO
     * @uses self::VALUE_SOUTH_AFRICA
     * @uses self::VALUE_CHILE
     * @uses self::VALUE_ARGENTINA
     * @uses self::VALUE_COLOMBIA
     * @uses self::VALUE_NEW_ZEALAND
     * @uses self::VALUE_TURKEY
     * @uses self::VALUE_BOTSWANA
     * @uses self::VALUE_PANAMA
     * @uses self::VALUE_COSTA_RICA
     * @uses self::VALUE_VENEZUELA
     * @uses self::VALUE_DOMINICAN_REPUBLIC
     * @uses self::VALUE_ECUADOR
     * @uses self::VALUE_GUATEMALA
     * @uses self::VALUE_PERU
     * @uses self::VALUE_HONDURAS
     * @uses self::VALUE_TRINIDAD_TOBAGO
     * @uses self::VALUE_AUSTRALIA
     * @uses self::VALUE_JAMAICA
     * @uses self::VALUE_BAHAMAS
     * @uses self::VALUE_SAINT_KITTS_NEVIS
     * @uses self::VALUE_BARBADOS
     * @uses self::VALUE_GHANA
     * @uses self::VALUE_SPAIN
     * @uses self::VALUE_PORTUGAL
     * @uses self::VALUE_URUGUAY
     * @uses self::VALUE_PARAGUAY
     * @uses self::VALUE_HONG_KONG
     * @uses self::VALUE_BOLIVIA
     * @uses self::VALUE_NIGERIA
     * @uses self::VALUE_BERMUDA
     * @uses self::VALUE_USVIRGIN_ISLANDS
     * @uses self::VALUE_NICARAGUA
     * @uses self::VALUE_EL_SALVADOR
     * @uses self::VALUE_INDIA
     * @uses self::VALUE_TURKS_CAICOS
     * @uses self::VALUE_UNITED_KINGDOM
     * @uses self::VALUE_MOZAMBIQUE
     * @uses self::VALUE_NETHERLANDS
     * @uses self::VALUE_BELGIUM
     * @uses self::VALUE_SWEDEN
     * @uses self::VALUE_SWITZERLAND
     * @uses self::VALUE_POLAND
     * @uses self::VALUE_THAILAND
     * @uses self::VALUE_FIJI
     * @uses self::VALUE_IRELAND
     * @uses self::VALUE_MALAYSIA
     * @uses self::VALUE_DENMARK
     * @uses self::VALUE_NORWAY
     * @uses self::VALUE_BRITISH_VIRGIN_ISLANDS
     * @uses self::VALUE_CAYMAN_ISLANDS
     * @uses self::VALUE_FRANCE
     * @uses self::VALUE_TAIWAN
     * @uses self::VALUE_CHINA
     * @uses self::VALUE_PHILIPPINES
     * @uses self::VALUE_CYPRUS
     * @uses self::VALUE_SAUDI_ARABIA
     * @uses self::VALUE_ICELAND
     * @uses self::VALUE_ISRAEL
     * @uses self::VALUE_SINGAPORE
     * @uses self::VALUE_LUXEMBOURG
     * @uses self::VALUE_UNITED_ARAB_EMIRATES
     * @uses self::VALUE_MALTA
     * @uses self::VALUE_GREECE
     * @uses self::VALUE_GUYANA
     * @uses self::VALUE_CROATIA
     * @uses self::VALUE_JAPAN
     * @uses self::VALUE_DOMINICA
     * @uses self::VALUE_BELIZE
     * @uses self::VALUE_FINLAND
     * @uses self::VALUE_GERMANY
     * @uses self::VALUE_ST_LUCIA
     * @uses self::VALUE_GRENADA
     * @uses self::VALUE_INDONESIA
     * @uses self::VALUE_BAHRAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_USA,
            self::VALUE_CANADA,
            self::VALUE_BRAZIL,
            self::VALUE_MEXICO,
            self::VALUE_SOUTH_AFRICA,
            self::VALUE_CHILE,
            self::VALUE_ARGENTINA,
            self::VALUE_COLOMBIA,
            self::VALUE_NEW_ZEALAND,
            self::VALUE_TURKEY,
            self::VALUE_BOTSWANA,
            self::VALUE_PANAMA,
            self::VALUE_COSTA_RICA,
            self::VALUE_VENEZUELA,
            self::VALUE_DOMINICAN_REPUBLIC,
            self::VALUE_ECUADOR,
            self::VALUE_GUATEMALA,
            self::VALUE_PERU,
            self::VALUE_HONDURAS,
            self::VALUE_TRINIDAD_TOBAGO,
            self::VALUE_AUSTRALIA,
            self::VALUE_JAMAICA,
            self::VALUE_BAHAMAS,
            self::VALUE_SAINT_KITTS_NEVIS,
            self::VALUE_BARBADOS,
            self::VALUE_GHANA,
            self::VALUE_SPAIN,
            self::VALUE_PORTUGAL,
            self::VALUE_URUGUAY,
            self::VALUE_PARAGUAY,
            self::VALUE_HONG_KONG,
            self::VALUE_BOLIVIA,
            self::VALUE_NIGERIA,
            self::VALUE_BERMUDA,
            self::VALUE_USVIRGIN_ISLANDS,
            self::VALUE_NICARAGUA,
            self::VALUE_EL_SALVADOR,
            self::VALUE_INDIA,
            self::VALUE_TURKS_CAICOS,
            self::VALUE_UNITED_KINGDOM,
            self::VALUE_MOZAMBIQUE,
            self::VALUE_NETHERLANDS,
            self::VALUE_BELGIUM,
            self::VALUE_SWEDEN,
            self::VALUE_SWITZERLAND,
            self::VALUE_POLAND,
            self::VALUE_THAILAND,
            self::VALUE_FIJI,
            self::VALUE_IRELAND,
            self::VALUE_MALAYSIA,
            self::VALUE_DENMARK,
            self::VALUE_NORWAY,
            self::VALUE_BRITISH_VIRGIN_ISLANDS,
            self::VALUE_CAYMAN_ISLANDS,
            self::VALUE_FRANCE,
            self::VALUE_TAIWAN,
            self::VALUE_CHINA,
            self::VALUE_PHILIPPINES,
            self::VALUE_CYPRUS,
            self::VALUE_SAUDI_ARABIA,
            self::VALUE_ICELAND,
            self::VALUE_ISRAEL,
            self::VALUE_SINGAPORE,
            self::VALUE_LUXEMBOURG,
            self::VALUE_UNITED_ARAB_EMIRATES,
            self::VALUE_MALTA,
            self::VALUE_GREECE,
            self::VALUE_GUYANA,
            self::VALUE_CROATIA,
            self::VALUE_JAPAN,
            self::VALUE_DOMINICA,
            self::VALUE_BELIZE,
            self::VALUE_FINLAND,
            self::VALUE_GERMANY,
            self::VALUE_ST_LUCIA,
            self::VALUE_GRENADA,
            self::VALUE_INDONESIA,
            self::VALUE_BAHRAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
