<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DualPathCommunicationStatus StructType
 * @subpackage Structs
 */
class DualPathCommunicationStatus extends AbstractStructBase
{
    /**
     * The DualEthernetWorking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DualEthernetWorking;
    /**
     * The DualCellWorking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DualCellWorking;
    /**
     * The DualEthernetDownSinceUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DualEthernetDownSinceUtc;
    /**
     * The DualCellDownSinceUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DualCellDownSinceUtc;
    /**
     * The DualEthernetUpSinceUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DualEthernetUpSinceUtc;
    /**
     * The DualCellUpSinceUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DualCellUpSinceUtc;
    /**
     * Constructor method for DualPathCommunicationStatus
     * @uses DualPathCommunicationStatus::setDualEthernetWorking()
     * @uses DualPathCommunicationStatus::setDualCellWorking()
     * @uses DualPathCommunicationStatus::setDualEthernetDownSinceUtc()
     * @uses DualPathCommunicationStatus::setDualCellDownSinceUtc()
     * @uses DualPathCommunicationStatus::setDualEthernetUpSinceUtc()
     * @uses DualPathCommunicationStatus::setDualCellUpSinceUtc()
     * @param bool $dualEthernetWorking
     * @param bool $dualCellWorking
     * @param string $dualEthernetDownSinceUtc
     * @param string $dualCellDownSinceUtc
     * @param string $dualEthernetUpSinceUtc
     * @param string $dualCellUpSinceUtc
     */
    public function __construct($dualEthernetWorking = null, $dualCellWorking = null, $dualEthernetDownSinceUtc = null, $dualCellDownSinceUtc = null, $dualEthernetUpSinceUtc = null, $dualCellUpSinceUtc = null)
    {
        $this
            ->setDualEthernetWorking($dualEthernetWorking)
            ->setDualCellWorking($dualCellWorking)
            ->setDualEthernetDownSinceUtc($dualEthernetDownSinceUtc)
            ->setDualCellDownSinceUtc($dualCellDownSinceUtc)
            ->setDualEthernetUpSinceUtc($dualEthernetUpSinceUtc)
            ->setDualCellUpSinceUtc($dualCellUpSinceUtc);
    }
    /**
     * Get DualEthernetWorking value
     * @return bool
     */
    public function getDualEthernetWorking()
    {
        return $this->DualEthernetWorking;
    }
    /**
     * Set DualEthernetWorking value
     * @param bool $dualEthernetWorking
     * @return \CustomerManagement\StructType\DualPathCommunicationStatus
     */
    public function setDualEthernetWorking($dualEthernetWorking = null)
    {
        // validation for constraint: boolean
        if (!is_null($dualEthernetWorking) && !is_bool($dualEthernetWorking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dualEthernetWorking, true), gettype($dualEthernetWorking)), __LINE__);
        }
        $this->DualEthernetWorking = $dualEthernetWorking;
        return $this;
    }
    /**
     * Get DualCellWorking value
     * @return bool
     */
    public function getDualCellWorking()
    {
        return $this->DualCellWorking;
    }
    /**
     * Set DualCellWorking value
     * @param bool $dualCellWorking
     * @return \CustomerManagement\StructType\DualPathCommunicationStatus
     */
    public function setDualCellWorking($dualCellWorking = null)
    {
        // validation for constraint: boolean
        if (!is_null($dualCellWorking) && !is_bool($dualCellWorking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dualCellWorking, true), gettype($dualCellWorking)), __LINE__);
        }
        $this->DualCellWorking = $dualCellWorking;
        return $this;
    }
    /**
     * Get DualEthernetDownSinceUtc value
     * @return string
     */
    public function getDualEthernetDownSinceUtc()
    {
        return $this->DualEthernetDownSinceUtc;
    }
    /**
     * Set DualEthernetDownSinceUtc value
     * @param string $dualEthernetDownSinceUtc
     * @return \CustomerManagement\StructType\DualPathCommunicationStatus
     */
    public function setDualEthernetDownSinceUtc($dualEthernetDownSinceUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dualEthernetDownSinceUtc) && !is_string($dualEthernetDownSinceUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dualEthernetDownSinceUtc, true), gettype($dualEthernetDownSinceUtc)), __LINE__);
        }
        $this->DualEthernetDownSinceUtc = $dualEthernetDownSinceUtc;
        return $this;
    }
    /**
     * Get DualCellDownSinceUtc value
     * @return string
     */
    public function getDualCellDownSinceUtc()
    {
        return $this->DualCellDownSinceUtc;
    }
    /**
     * Set DualCellDownSinceUtc value
     * @param string $dualCellDownSinceUtc
     * @return \CustomerManagement\StructType\DualPathCommunicationStatus
     */
    public function setDualCellDownSinceUtc($dualCellDownSinceUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dualCellDownSinceUtc) && !is_string($dualCellDownSinceUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dualCellDownSinceUtc, true), gettype($dualCellDownSinceUtc)), __LINE__);
        }
        $this->DualCellDownSinceUtc = $dualCellDownSinceUtc;
        return $this;
    }
    /**
     * Get DualEthernetUpSinceUtc value
     * @return string
     */
    public function getDualEthernetUpSinceUtc()
    {
        return $this->DualEthernetUpSinceUtc;
    }
    /**
     * Set DualEthernetUpSinceUtc value
     * @param string $dualEthernetUpSinceUtc
     * @return \CustomerManagement\StructType\DualPathCommunicationStatus
     */
    public function setDualEthernetUpSinceUtc($dualEthernetUpSinceUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dualEthernetUpSinceUtc) && !is_string($dualEthernetUpSinceUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dualEthernetUpSinceUtc, true), gettype($dualEthernetUpSinceUtc)), __LINE__);
        }
        $this->DualEthernetUpSinceUtc = $dualEthernetUpSinceUtc;
        return $this;
    }
    /**
     * Get DualCellUpSinceUtc value
     * @return string
     */
    public function getDualCellUpSinceUtc()
    {
        return $this->DualCellUpSinceUtc;
    }
    /**
     * Set DualCellUpSinceUtc value
     * @param string $dualCellUpSinceUtc
     * @return \CustomerManagement\StructType\DualPathCommunicationStatus
     */
    public function setDualCellUpSinceUtc($dualCellUpSinceUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dualCellUpSinceUtc) && !is_string($dualCellUpSinceUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dualCellUpSinceUtc, true), gettype($dualCellUpSinceUtc)), __LINE__);
        }
        $this->DualCellUpSinceUtc = $dualCellUpSinceUtc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\DualPathCommunicationStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
