<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadToPanel StructType
 * @subpackage Structs
 */
class DownloadToPanel extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The panelSettings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfPanelSettingInput
     */
    public $panelSettings;
    /**
     * Constructor method for DownloadToPanel
     * @uses DownloadToPanel::setCustomerId()
     * @uses DownloadToPanel::setPanelSettings()
     * @param int $customerId
     * @param \CustomerManagement\ArrayType\ArrayOfPanelSettingInput $panelSettings
     */
    public function __construct($customerId = null, \CustomerManagement\ArrayType\ArrayOfPanelSettingInput $panelSettings = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPanelSettings($panelSettings);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\DownloadToPanel
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get panelSettings value
     * @return \CustomerManagement\ArrayType\ArrayOfPanelSettingInput|null
     */
    public function getPanelSettings()
    {
        return $this->panelSettings;
    }
    /**
     * Set panelSettings value
     * @param \CustomerManagement\ArrayType\ArrayOfPanelSettingInput $panelSettings
     * @return \CustomerManagement\StructType\DownloadToPanel
     */
    public function setPanelSettings(\CustomerManagement\ArrayType\ArrayOfPanelSettingInput $panelSettings = null)
    {
        $this->panelSettings = $panelSettings;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\DownloadToPanel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
