<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeviceNotesOutput StructType
 * @subpackage Structs
 */
class GetDeviceNotesOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The GeneralDeviceNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfGeneralDeviceNote
     */
    public $GeneralDeviceNotes;
    /**
     * The EquipmentDeviceNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfEquipmentDeviceNote
     */
    public $EquipmentDeviceNotes;
    /**
     * Constructor method for GetDeviceNotesOutput
     * @uses GetDeviceNotesOutput::setSuccess()
     * @uses GetDeviceNotesOutput::setErrorMessage()
     * @uses GetDeviceNotesOutput::setGeneralDeviceNotes()
     * @uses GetDeviceNotesOutput::setEquipmentDeviceNotes()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfGeneralDeviceNote $generalDeviceNotes
     * @param \CustomerManagement\ArrayType\ArrayOfEquipmentDeviceNote $equipmentDeviceNotes
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfGeneralDeviceNote $generalDeviceNotes = null, \CustomerManagement\ArrayType\ArrayOfEquipmentDeviceNote $equipmentDeviceNotes = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setGeneralDeviceNotes($generalDeviceNotes)
            ->setEquipmentDeviceNotes($equipmentDeviceNotes);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetDeviceNotesOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetDeviceNotesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get GeneralDeviceNotes value
     * @return \CustomerManagement\ArrayType\ArrayOfGeneralDeviceNote|null
     */
    public function getGeneralDeviceNotes()
    {
        return $this->GeneralDeviceNotes;
    }
    /**
     * Set GeneralDeviceNotes value
     * @param \CustomerManagement\ArrayType\ArrayOfGeneralDeviceNote $generalDeviceNotes
     * @return \CustomerManagement\StructType\GetDeviceNotesOutput
     */
    public function setGeneralDeviceNotes(\CustomerManagement\ArrayType\ArrayOfGeneralDeviceNote $generalDeviceNotes = null)
    {
        $this->GeneralDeviceNotes = $generalDeviceNotes;
        return $this;
    }
    /**
     * Get EquipmentDeviceNotes value
     * @return \CustomerManagement\ArrayType\ArrayOfEquipmentDeviceNote|null
     */
    public function getEquipmentDeviceNotes()
    {
        return $this->EquipmentDeviceNotes;
    }
    /**
     * Set EquipmentDeviceNotes value
     * @param \CustomerManagement\ArrayType\ArrayOfEquipmentDeviceNote $equipmentDeviceNotes
     * @return \CustomerManagement\StructType\GetDeviceNotesOutput
     */
    public function setEquipmentDeviceNotes(\CustomerManagement\ArrayType\ArrayOfEquipmentDeviceNote $equipmentDeviceNotes = null)
    {
        $this->EquipmentDeviceNotes = $equipmentDeviceNotes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\GetDeviceNotesOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
